/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import java.util.Set;
import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.jdt.core.IClasspathEntry;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.internal.core.ExternalFoldersManager;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelManager;
import orika_shaded.org.eclipse.jdt.internal.core.JavaProject;

public class ExternalFolderChange {
    private JavaProject project;
    private IClasspathEntry[] oldResolvedClasspath;

    public ExternalFolderChange(JavaProject project, IClasspathEntry[] oldResolvedClasspath) {
        this.project = project;
        this.oldResolvedClasspath = oldResolvedClasspath;
    }

    public void updateExternalFoldersIfNecessary(boolean refreshIfExistAlready, IProgressMonitor monitor) throws JavaModelException {
        Set<IPath> oldFolders = ExternalFoldersManager.getExternalFolders(this.oldResolvedClasspath);
        IClasspathEntry[] newResolvedClasspath = this.project.getResolvedClasspath();
        Set<IPath> newFolders = ExternalFoldersManager.getExternalFolders(newResolvedClasspath);
        if (newFolders == null) {
            return;
        }
        ExternalFoldersManager foldersManager = JavaModelManager.getExternalManager();
        for (IPath folderPath : newFolders) {
            if (oldFolders != null && oldFolders.remove(folderPath) && !foldersManager.removePendingFolder(folderPath)) continue;
            try {
                foldersManager.createLinkFolder(folderPath, refreshIfExistAlready, monitor);
            }
            catch (CoreException e) {
                throw new JavaModelException(e);
            }
        }
    }

    public String toString() {
        return "ExternalFolderChange: " + this.project.getElementName();
    }
}

