/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import orika_shaded.org.eclipse.core.resources.IResource;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.core.runtime.Path;
import orika_shaded.org.eclipse.jdt.core.IClassFile;
import orika_shaded.org.eclipse.jdt.core.ICompilationUnit;
import orika_shaded.org.eclipse.jdt.core.IJarEntryResource;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.internal.core.ClassFile;
import orika_shaded.org.eclipse.jdt.internal.core.JarEntryDirectory;
import orika_shaded.org.eclipse.jdt.internal.core.JarEntryFile;
import orika_shaded.org.eclipse.jdt.internal.core.JarEntryResource;
import orika_shaded.org.eclipse.jdt.internal.core.JarPackageFragmentInfo;
import orika_shaded.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.internal.core.JarPackageFragmentRootInfo;
import orika_shaded.org.eclipse.jdt.internal.core.JavaElementInfo;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelStatus;
import orika_shaded.org.eclipse.jdt.internal.core.ModularClassFile;
import orika_shaded.org.eclipse.jdt.internal.core.OpenableElementInfo;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragment;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

class JarPackageFragment
extends PackageFragment {
    protected JarPackageFragment(PackageFragmentRoot root, String[] names) {
        super(root, names);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        JarPackageFragmentRoot root = (JarPackageFragmentRoot)this.getParent();
        JarPackageFragmentRootInfo parentInfo = (JarPackageFragmentRootInfo)root.getElementInfo();
        ArrayList[] entries = (ArrayList[])parentInfo.rawPackageInfo.get(this.names);
        if (entries == null) {
            throw this.newNotPresentException();
        }
        JarPackageFragmentInfo fragInfo = (JarPackageFragmentInfo)info;
        fragInfo.setChildren(this.computeChildren(entries[0]));
        fragInfo.setNonJavaResources(this.computeNonJavaResources(entries[1]));
        newElements.put(this, fragInfo);
        return true;
    }

    private IJavaElement[] computeChildren(ArrayList namesWithoutExtension) {
        int size = namesWithoutExtension.size();
        if (size == 0) {
            return NO_ELEMENTS;
        }
        IJavaElement[] children = new IJavaElement[size];
        int i = 0;
        while (i < size) {
            String nameWithoutExtension = (String)namesWithoutExtension.get(i);
            children[i] = "module-info".equals(nameWithoutExtension) ? new ModularClassFile(this) : new ClassFile(this, nameWithoutExtension);
            ++i;
        }
        return children;
    }

    private Object[] computeNonJavaResources(ArrayList entryNames) {
        int length = entryNames.size();
        if (length == 0) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        HashMap<IPath, JarEntryResource> jarEntries = new HashMap<IPath, JarEntryResource>();
        HashMap<IPath, ArrayList<IPath>> childrenMap = new HashMap<IPath, ArrayList<IPath>>();
        ArrayList<JarEntryResource> topJarEntries = new ArrayList<JarEntryResource>();
        int i = 0;
        while (i < length) {
            Path filePath;
            IPath childPath;
            String resName = (String)entryNames.get(i);
            if (!Util.isJavaLikeFileName(resName) && !jarEntries.containsKey(childPath = (filePath = new Path(resName)).removeFirstSegments(this.names.length))) {
                JarEntryFile file = new JarEntryFile(filePath.lastSegment());
                jarEntries.put(childPath, file);
                if (childPath.segmentCount() == 1) {
                    file.setParent(this);
                    topJarEntries.add(file);
                } else {
                    IPath parentPath = childPath.removeLastSegments(1);
                    while (parentPath.segmentCount() > 0) {
                        ArrayList<IPath> parentChildren = (ArrayList<IPath>)childrenMap.get(parentPath);
                        if (parentChildren == null) {
                            JarEntryDirectory dir = new JarEntryDirectory(parentPath.lastSegment());
                            jarEntries.put(parentPath, dir);
                            parentChildren = new ArrayList<IPath>();
                            childrenMap.put(parentPath, parentChildren);
                            parentChildren.add(childPath);
                            if (parentPath.segmentCount() == 1) {
                                topJarEntries.add(dir);
                                break;
                            }
                            childPath = parentPath;
                            parentPath = childPath.removeLastSegments(1);
                            continue;
                        }
                        parentChildren.add(childPath);
                        break;
                    }
                }
            }
            ++i;
        }
        for (Map.Entry entry : childrenMap.entrySet()) {
            IPath entryPath = (IPath)entry.getKey();
            ArrayList entryValue = (ArrayList)entry.getValue();
            JarEntryDirectory jarEntryDirectory = (JarEntryDirectory)jarEntries.get(entryPath);
            int size = entryValue.size();
            IJarEntryResource[] children = new IJarEntryResource[size];
            int i2 = 0;
            while (i2 < size) {
                JarEntryResource child = (JarEntryResource)jarEntries.get(entryValue.get(i2));
                child.setParent(jarEntryDirectory);
                children[i2] = child;
                ++i2;
            }
            jarEntryDirectory.setChildren(children);
            if (entryPath.segmentCount() != 1) continue;
            jarEntryDirectory.setParent(this);
        }
        return topJarEntries.toArray(new Object[topJarEntries.size()]);
    }

    @Override
    public boolean containsJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).containsJavaResources();
    }

    @Override
    public ICompilationUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    @Override
    protected Object createElementInfo() {
        return new JarPackageFragmentInfo();
    }

    @Override
    public IClassFile[] getAllClassFiles() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(6);
        IClassFile[] array = new IClassFile[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public ICompilationUnit[] getCompilationUnits() {
        return NO_COMPILATION_UNITS;
    }

    @Override
    public IResource getCorrespondingResource() {
        return null;
    }

    @Override
    public Object[] getNonJavaResources() throws JavaModelException {
        if (this.isDefaultPackage()) {
            return JavaElementInfo.NO_NON_JAVA_RESOURCES;
        }
        return this.storedNonJavaResources();
    }

    @Override
    protected boolean internalIsValidPackageName() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    protected Object[] storedNonJavaResources() throws JavaModelException {
        return ((JarPackageFragmentInfo)this.getElementInfo()).getNonJavaResources();
    }
}

