/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import orika_shaded.org.eclipse.core.resources.IResource;
import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.jdt.core.CompletionRequestor;
import orika_shaded.org.eclipse.jdt.core.IBuffer;
import orika_shaded.org.eclipse.jdt.core.ICompilationUnit;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.core.IModularClassFile;
import orika_shaded.org.eclipse.jdt.core.IModuleDescription;
import orika_shaded.org.eclipse.jdt.core.IType;
import orika_shaded.org.eclipse.jdt.core.JavaCore;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.WorkingCopyOwner;
import orika_shaded.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import orika_shaded.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import orika_shaded.org.eclipse.jdt.internal.core.AbstractClassFile;
import orika_shaded.org.eclipse.jdt.internal.core.BasicCompilationUnit;
import orika_shaded.org.eclipse.jdt.internal.core.BecomeWorkingCopyOperation;
import orika_shaded.org.eclipse.jdt.internal.core.BinaryModule;
import orika_shaded.org.eclipse.jdt.internal.core.BufferManager;
import orika_shaded.org.eclipse.jdt.internal.core.ClassFileInfo;
import orika_shaded.org.eclipse.jdt.internal.core.ClassFileWorkingCopy;
import orika_shaded.org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import orika_shaded.org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.internal.core.JavaElement;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelManager;
import orika_shaded.org.eclipse.jdt.internal.core.JrtPackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.internal.core.NamedMember;
import orika_shaded.org.eclipse.jdt.internal.core.OpenableElementInfo;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragment;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import orika_shaded.org.eclipse.jdt.internal.core.PackageFragmentRootInfo;
import orika_shaded.org.eclipse.jdt.internal.core.SourceMapper;
import orika_shaded.org.eclipse.jdt.internal.core.nd.java.model.BinaryModuleDescriptor;
import orika_shaded.org.eclipse.jdt.internal.core.nd.java.model.BinaryModuleFactory;
import orika_shaded.org.eclipse.jdt.internal.core.util.MementoTokenizer;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class ModularClassFile
extends AbstractClassFile
implements IModularClassFile {
    private BinaryModule binaryModule;

    protected ModularClassFile(PackageFragment parent) {
        super(parent, "module-info");
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        IBinaryModule moduleInfo = this.getBinaryModuleInfo();
        if (moduleInfo == null) {
            info.setChildren(JavaElement.NO_ELEMENTS);
            return false;
        }
        BinaryModule module = ((ClassFileInfo)info).readBinaryModule(this, (HashMap)newElements, moduleInfo);
        if (module != null) {
            this.binaryModule = module;
            info.setChildren(new IJavaElement[]{module});
            ((PackageFragmentRootInfo)this.getPackageFragmentRoot().getElementInfo()).setModule(module);
        }
        return true;
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        String source = this.getSource();
        if (source != null) {
            BasicCompilationUnit cu = new BasicCompilationUnit(this.getSource().toCharArray(), null, "module-info.java", this.getJavaProject());
            this.codeComplete(cu, cu, offset, requestor, owner, null, monitor);
        }
    }

    @Override
    public IJavaElement[] codeSelect(int offset, int length, WorkingCopyOwner owner) throws JavaModelException {
        char[] contents;
        IBuffer buffer = this.getBuffer();
        if (buffer != null && (contents = buffer.getCharacters()) != null) {
            BasicCompilationUnit cu = new BasicCompilationUnit(contents, null, "module-info.java", this);
            return super.codeSelect(cu, offset, length, owner);
        }
        return new IJavaElement[0];
    }

    @Override
    public IType findPrimaryType() {
        return null;
    }

    @Override
    public boolean isClass() throws JavaModelException {
        return false;
    }

    @Override
    public boolean isInterface() throws JavaModelException {
        return false;
    }

    @Override
    public IType getType() {
        throw new UnsupportedOperationException("IClassFile#getType() cannot be used on an IModularClassFile");
    }

    public IBinaryModule getBinaryModuleInfo() throws JavaModelException {
        try {
            IBinaryModule info = this.getJarBinaryModuleInfo();
            if (info == null) {
                throw this.newNotPresentException();
            }
            return info;
        }
        catch (ClassFormatException cfe) {
            if (JavaCore.getPlugin().isDebugging()) {
                cfe.printStackTrace(System.err);
            }
            return null;
        }
        catch (IOException ioe) {
            throw new JavaModelException(ioe, 985);
        }
        catch (CoreException e) {
            if (e instanceof JavaModelException) {
                throw (JavaModelException)e;
            }
            throw new JavaModelException(e);
        }
    }

    private IBinaryModule getJarBinaryModuleInfo() throws CoreException, IOException, ClassFormatException {
        BinaryModuleDescriptor descriptor = BinaryModuleFactory.createDescriptor(this);
        if (descriptor == null) {
            return null;
        }
        IBinaryModule result = null;
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (this.getPackageFragmentRoot() instanceof JarPackageFragmentRoot) {
            if (root instanceof JrtPackageFragmentRoot || this.name.equals("module-info")) {
                String entryName;
                PackageFragment pkg = (PackageFragment)this.getParent();
                JarPackageFragmentRoot jarRoot = (JarPackageFragmentRoot)this.getPackageFragmentRoot();
                byte[] contents = this.getClassFileContent(jarRoot, entryName = jarRoot.getClassFilePath(Util.concatWith(pkg.names, this.getElementName(), '/')));
                if (contents != null) {
                    int slash;
                    String rootPath = root.getPath().toOSString();
                    String rootIdentifier = root.getHandleIdentifier();
                    if (orika_shaded.org.eclipse.jdt.internal.compiler.util.Util.isJrt(rootPath) && (slash = rootIdentifier.lastIndexOf(47)) != -1) {
                        rootIdentifier = rootIdentifier.substring(0, slash);
                    }
                    String fileName = String.valueOf(rootIdentifier) + '|' + entryName;
                    ClassFileReader classFileReader = new ClassFileReader(contents, fileName.toCharArray(), false);
                    return classFileReader.getModuleDeclaration();
                }
            } else {
                result = BinaryModuleFactory.readModule(descriptor, null);
            }
        } else {
            result = BinaryModuleFactory.readModule(descriptor, null);
        }
        return result;
    }

    @Override
    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement parentElement = this.getParent();
        while (parentElement.getElementType() != 3) {
            parentElement = parentElement.getParent();
        }
        PackageFragmentRoot root = (PackageFragmentRoot)parentElement;
        SourceMapper mapper = root.getSourceMapper();
        if (mapper == null) {
            return null;
        }
        this.getBuffer();
        IModuleDescription module = this.getModule();
        return this.findElement(module, position, mapper);
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '`': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String modName = memento.nextToken();
                BinaryModule mod = new BinaryModule(this, modName);
                return mod.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '\'';
    }

    @Override
    protected void escapeMementoName(StringBuffer buffer, String mementoName) {
    }

    @Override
    public ICompilationUnit getWorkingCopy(WorkingCopyOwner owner, IProgressMonitor monitor) throws JavaModelException {
        ClassFileWorkingCopy workingCopy = new ClassFileWorkingCopy(this, owner == null ? DefaultWorkingCopyOwner.PRIMARY : owner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy, false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, null);
        op.runOperation(monitor);
        return workingCopy;
    }

    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaModelException {
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            return this.mapSource(mapper);
        }
        return null;
    }

    private IBuffer mapSource(SourceMapper mapper) throws JavaModelException {
        char[] contents = mapper.findSource(this.getModule());
        if (contents != null) {
            IBuffer buffer = BufferManager.createBuffer(this);
            if (buffer == null) {
                return null;
            }
            BufferManager bufManager = this.getBufferManager();
            bufManager.addBuffer(buffer);
            if (buffer.getCharacters() == null) {
                buffer.setContents(contents);
            }
            buffer.addBufferChangedListener(this);
            mapper.mapSource((NamedMember)((Object)this.getModule()), contents, null);
            return buffer;
        }
        IBuffer buffer = BufferManager.createNullBuffer(this);
        if (buffer == null) {
            return null;
        }
        BufferManager bufManager = this.getBufferManager();
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    @Override
    public IModuleDescription getModule() throws JavaModelException {
        if (this.binaryModule == null) {
            this.openWhenClosed(this.createElementInfo(), false, null);
            if (this.binaryModule == null) {
                throw this.newNotPresentException();
            }
        }
        return this.binaryModule;
    }
}

