/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import orika_shaded.org.eclipse.jdt.core.IClasspathAttribute;
import orika_shaded.org.eclipse.jdt.core.IClasspathEntry;
import orika_shaded.org.eclipse.jdt.core.IModuleDescription;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelStatus;
import orika_shaded.org.eclipse.jdt.internal.core.JavaProject;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class ModuleUpdater {
    private JavaProject javaProoject;
    private Map<String, IUpdatableModule.UpdatesByKind> moduleUpdates = new HashMap<String, IUpdatableModule.UpdatesByKind>();

    public ModuleUpdater(JavaProject javaProject) {
        this.javaProoject = javaProject;
    }

    public void computeModuleUpdates(IClasspathEntry entry) throws JavaModelException {
        IClasspathAttribute[] iClasspathAttributeArray = entry.getExtraAttributes();
        int n = iClasspathAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            int n3;
            int n4;
            String[] stringArray;
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            String attributeName = attribute.getName();
            String values = attribute.getValue();
            if (attributeName.equals("add-exports")) {
                stringArray = values.split(":");
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    value = stringArray[n3];
                    int slash = value.indexOf(47);
                    int equals = value.indexOf(61);
                    if (slash != -1 && equals != -1) {
                        String modName = value.substring(0, slash);
                        char[] packName = value.substring(slash + 1, equals).toCharArray();
                        char[][] targets = CharOperation.splitOn(',', value.substring(equals + 1).toCharArray());
                        this.addModuleUpdate(modName, m -> m.addExports(packName, targets), IUpdatableModule.UpdateKind.PACKAGE);
                    } else {
                        Util.log(2, "Invalid argument to add-exports: " + value);
                    }
                    ++n3;
                }
            } else if (attributeName.equals("add-reads")) {
                stringArray = values.split(":");
                n4 = stringArray.length;
                n3 = 0;
                while (n3 < n4) {
                    value = stringArray[n3];
                    int equals = value.indexOf(61);
                    if (equals != -1) {
                        String srcMod = value.substring(0, equals);
                        char[] targetMod = value.substring(equals + 1).toCharArray();
                        this.addModuleUpdate(srcMod, m -> m.addReads(targetMod), IUpdatableModule.UpdateKind.MODULE);
                    } else {
                        Util.log(2, "Invalid argument to add-reads: " + value);
                    }
                    ++n3;
                }
            } else if (attributeName.equals("module-main-class")) {
                IModuleDescription module = this.javaProoject.getModuleDescription();
                if (module == null) {
                    throw new JavaModelException(new JavaModelStatus(969));
                }
                this.addModuleUpdate(module.getElementName(), m -> m.setMainClassName(values.toCharArray()), IUpdatableModule.UpdateKind.MODULE);
            }
            ++n2;
        }
    }

    public void addModuleUpdate(String moduleName, Consumer<IUpdatableModule> update, IUpdatableModule.UpdateKind kind) {
        IUpdatableModule.UpdatesByKind updates = this.moduleUpdates.get(moduleName);
        if (updates == null) {
            updates = new IUpdatableModule.UpdatesByKind();
            this.moduleUpdates.put(moduleName, updates);
        }
        updates.getList(kind, true).add(update);
    }

    public void applyModuleUpdates(IUpdatableModule compilerModule, IUpdatableModule.UpdateKind kind) {
        IUpdatableModule.UpdatesByKind updates;
        char[] name = compilerModule.name();
        if (name != ModuleBinding.UNNAMED && (updates = this.moduleUpdates.get(String.valueOf(name))) != null) {
            for (Consumer<IUpdatableModule> update : updates.getList(kind, false)) {
                update.accept(compilerModule);
            }
        }
    }
}

