/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import orika_shaded.org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import orika_shaded.org.eclipse.jdt.internal.compiler.classfmt.ExternalAnnotationDecorator;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import orika_shaded.org.eclipse.jdt.internal.core.builder.ClasspathJar;

public class ClasspathJMod
extends ClasspathJar {
    public static char[] CLASSES = "classes".toCharArray();
    public static char[] CLASSES_FOLDER = "classes/".toCharArray();
    private static int MODULE_DESCRIPTOR_NAME_LENGTH = "module-info.class".length();

    ClasspathJMod(String zipFilename, long lastModified, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        super(zipFilename, lastModified, accessRuleSet, externalAnnotationPath, true);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        block12: {
            if (!this.isPackage(qualifiedPackageName, moduleName)) {
                return null;
            }
            try {
                char[] modName;
                qualifiedBinaryFileName = new String(CharOperation.append(CLASSES_FOLDER, qualifiedBinaryFileName.toCharArray()));
                IBinaryType reader = ClassFileReader.read(this.zipFile, qualifiedBinaryFileName);
                if (reader == null) break block12;
                char[] cArray = modName = this.module == null ? null : this.module.name();
                if (reader instanceof ClassFileReader) {
                    ClassFileReader classReader = reader;
                    if (classReader.moduleName == null) {
                        classReader.moduleName = modName;
                    } else {
                        modName = classReader.moduleName;
                    }
                }
                String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                if (this.externalAnnotationPath != null) {
                    try {
                        if (this.annotationZipFile == null) {
                            this.annotationZipFile = ExternalAnnotationDecorator.getAnnotationZipFile(this.externalAnnotationPath, null);
                        }
                        reader = ExternalAnnotationDecorator.create(reader, this.externalAnnotationPath, fileNameWithoutExtension, this.annotationZipFile);
                    }
                    catch (IOException iOException) {}
                }
                if (this.accessRuleSet == null) {
                    return new NameEnvironmentAnswer(reader, null, modName);
                }
                return new NameEnvironmentAnswer(reader, this.accessRuleSet.getViolatedRestriction(fileNameWithoutExtension.toCharArray()), modName);
            }
            catch (IOException iOException) {
            }
            catch (ClassFormatException classFormatException) {}
        }
        return null;
    }

    @Override
    protected String readJarContent(SimpleSet packageSet) {
        String modInfo = null;
        Enumeration<? extends ZipEntry> e = this.zipFile.entries();
        while (e.hasMoreElements()) {
            char[] folder;
            ZipEntry entry = e.nextElement();
            char[] entryName = entry.getName().toCharArray();
            int index = CharOperation.indexOf('/', entryName);
            if (index == -1 || !CharOperation.equals(CLASSES, folder = CharOperation.subarray(entryName, 0, index))) continue;
            char[] fileName = CharOperation.subarray(entryName, index + 1, entryName.length);
            if (modInfo == null && fileName.length == MODULE_DESCRIPTOR_NAME_LENGTH && CharOperation.equals(fileName, "module-info.class".toCharArray())) {
                modInfo = new String(entryName);
            }
            ClasspathJMod.addToPackageSet(packageSet, new String(fileName), false);
        }
        return modInfo;
    }
}

