/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import orika_shaded.org.eclipse.core.resources.IContainer;
import orika_shaded.org.eclipse.core.resources.IFile;
import orika_shaded.org.eclipse.core.resources.IFolder;
import orika_shaded.org.eclipse.core.resources.IMarker;
import orika_shaded.org.eclipse.core.resources.IProject;
import orika_shaded.org.eclipse.core.resources.IResource;
import orika_shaded.org.eclipse.core.resources.IWorkspaceRoot;
import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.jdt.core.IClasspathEntry;
import orika_shaded.org.eclipse.jdt.core.IJavaProject;
import orika_shaded.org.eclipse.jdt.core.IModuleDescription;
import orika_shaded.org.eclipse.jdt.core.JavaCore;
import orika_shaded.org.eclipse.jdt.core.JavaModelException;
import orika_shaded.org.eclipse.jdt.core.compiler.CharOperation;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IModule;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import orika_shaded.org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import orika_shaded.org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import orika_shaded.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SimpleSet;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import orika_shaded.org.eclipse.jdt.internal.compiler.util.Util;
import orika_shaded.org.eclipse.jdt.internal.core.AbstractModule;
import orika_shaded.org.eclipse.jdt.internal.core.ClasspathEntry;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModel;
import orika_shaded.org.eclipse.jdt.internal.core.JavaProject;
import orika_shaded.org.eclipse.jdt.internal.core.ModuleDescriptionInfo;
import orika_shaded.org.eclipse.jdt.internal.core.ModuleUpdater;
import orika_shaded.org.eclipse.jdt.internal.core.SourceModule;
import orika_shaded.org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import orika_shaded.org.eclipse.jdt.internal.core.builder.BuildNotifier;
import orika_shaded.org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import orika_shaded.org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import orika_shaded.org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import orika_shaded.org.eclipse.jdt.internal.core.builder.ModuleEntryProcessor;
import orika_shaded.org.eclipse.jdt.internal.core.builder.ModulePathEntry;
import orika_shaded.org.eclipse.jdt.internal.core.builder.SourceFile;

public class NameEnvironment
implements IModuleAwareNameEnvironment,
SuffixConstants {
    boolean isIncrementalBuild = false;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    Map<String, IModulePathEntry> modulePathEntries;
    BuildNotifier notifier;
    SimpleSet initialTypeNames;
    SimpleLookupTable additionalUnits;
    ModuleUpdater moduleUpdater;

    NameEnvironment(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject, BuildNotifier notifier) throws CoreException {
        this.notifier = notifier;
        this.computeClasspathLocations(root, javaProject, binaryLocationsPerProject);
        this.setNames(null, null);
    }

    public NameEnvironment(IJavaProject javaProject) {
        try {
            this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject, null);
        }
        catch (CoreException coreException) {
            this.sourceLocations = new ClasspathMultiDirectory[0];
            this.binaryLocations = new ClasspathLocation[0];
        }
        this.setNames(null, null);
    }

    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        IMarker cycleMarker = javaProject.getCycleMarker();
        if (cycleMarker != null) {
            int severity;
            int n = severity = "error".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.circularClasspath", true)) ? 2 : 1;
            if (severity != cycleMarker.getAttribute("severity", severity)) {
                cycleMarker.setAttribute("severity", severity);
            }
        }
        IClasspathEntry[] classpathEntries = javaProject.getExpandedClasspath();
        ArrayList<ClasspathLocation> sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        ArrayList<ClasspathLocation> bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
        HashMap<String, IModulePathEntry> moduleEntries = null;
        if (CompilerOptions.versionToJdkLevel(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.compliance", true)) >= 0x350000L) {
            moduleEntries = new HashMap<String, IModulePathEntry>(classpathEntries.length);
            this.moduleUpdater = new ModuleUpdater(javaProject);
        }
        IModuleDescription projectModule = javaProject.getModuleDescription();
        String patchedModuleName = ModuleEntryProcessor.pushPatchToFront(classpathEntries);
        IModule patchedModule = null;
        int i = 0;
        int l = classpathEntries.length;
        while (i < l) {
            if (i == 1 && patchedModuleName != null) {
                patchedModuleName = null;
            }
            ClasspathEntry entry = (ClasspathEntry)classpathEntries[i];
            IPath path = entry.getPath();
            Object target = JavaModel.getTarget(path, true);
            IPath externalAnnotationPath = ClasspathEntry.getExternalAnnotationPath(entry, javaProject.getProject(), true);
            if (target != null) {
                boolean isOnModulePath = this.isOnModulePath(entry);
                Set<String> limitModules = ModuleEntryProcessor.computeLimitModules(entry);
                if (patchedModuleName != null && limitModules != null && !limitModules.contains(patchedModuleName)) {
                    patchedModuleName = null;
                }
                if (this.moduleUpdater != null) {
                    this.moduleUpdater.computeModuleUpdates(entry);
                }
                switch (entry.getEntryKind()) {
                    case 3: {
                        IProject outputFolder;
                        IPath outputPath;
                        if (!(target instanceof IContainer)) break;
                        IPath iPath = outputPath = entry.getOutputLocation() != null ? entry.getOutputLocation() : javaProject.getOutputLocation();
                        if (outputPath.segmentCount() == 1) {
                            outputFolder = javaProject.getProject();
                        } else {
                            outputFolder = root.getFolder(outputPath);
                            if (!outputFolder.exists()) {
                                this.createOutputFolder((IContainer)outputFolder);
                            }
                        }
                        ClasspathLocation sourceLocation = ClasspathLocation.forSourceFolder((IContainer)target, (IContainer)outputFolder, entry.fullInclusionPatternChars(), entry.fullExclusionPatternChars(), entry.ignoreOptionalProblems());
                        if (patchedModule != null) {
                            ModuleEntryProcessor.combinePatchIntoModuleEntry(sourceLocation, patchedModule, moduleEntries);
                        }
                        sLocations.add(sourceLocation);
                        break;
                    }
                    case 2: {
                        IProject prereqProject;
                        if (!(target instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target)) break;
                        JavaProject prereqJavaProject = (JavaProject)JavaCore.create(prereqProject);
                        IClasspathEntry[] prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                        ArrayList<IProject> seen = new ArrayList<IProject>();
                        ArrayList<ClasspathLocation> projectLocations = new ArrayList<ClasspathLocation>();
                        int j = 0;
                        int m = prereqClasspathEntries.length;
                        while (j < m) {
                            Object prereqTarget;
                            IClasspathEntry prereqEntry = prereqClasspathEntries[j];
                            if (prereqEntry.getEntryKind() == 3 && (prereqTarget = JavaModel.getTarget(prereqEntry.getPath(), true)) instanceof IContainer) {
                                IProject binaryFolder;
                                IPath prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                                Object object = binaryFolder = prereqOutputPath.segmentCount() == 1 ? prereqProject : root.getFolder(prereqOutputPath);
                                if (binaryFolder.exists() && !seen.contains(binaryFolder)) {
                                    seen.add(binaryFolder);
                                    ClasspathLocation bLocation = ClasspathLocation.forBinaryFolder((IContainer)binaryFolder, true, entry.getAccessRuleSet(), externalAnnotationPath, isOnModulePath);
                                    bLocations.add(bLocation);
                                    projectLocations.add(bLocation);
                                    if (binaryLocationsPerProject != null) {
                                        ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(prereqProject);
                                        if (existingLocations == null) {
                                            existingLocations = new ClasspathLocation[]{bLocation};
                                        } else {
                                            int size = existingLocations.length;
                                            ClasspathLocation[] classpathLocationArray = existingLocations;
                                            existingLocations = new ClasspathLocation[size + 1];
                                            System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                            existingLocations[size] = bLocation;
                                        }
                                        binaryLocationsPerProject.put(prereqProject, existingLocations);
                                    }
                                }
                            }
                            ++j;
                        }
                        if (moduleEntries == null || !isOnModulePath || projectLocations.size() <= 0) break;
                        IModule info = null;
                        try {
                            IModuleDescription mod = prereqJavaProject.getModuleDescription();
                            if (mod != null) {
                                SourceModule sourceModule = (SourceModule)mod;
                                info = (ModuleDescriptionInfo)sourceModule.getElementInfo();
                            }
                        }
                        catch (JavaModelException javaModelException) {}
                        if (info == null) {
                            info = IModule.createAutomatic(prereqJavaProject.getElementName(), false, prereqJavaProject.getManifest());
                        }
                        ModulePathEntry projectEntry = new ModulePathEntry(prereqJavaProject.getPath(), info, projectLocations.toArray(new ClasspathLocation[projectLocations.size()]));
                        String moduleName = String.valueOf(info.name());
                        if (limitModules != null && !limitModules.contains(moduleName)) break;
                        moduleEntries.put(moduleName, projectEntry);
                        if (!moduleName.equals(patchedModuleName)) break;
                        patchedModule = info;
                        break;
                    }
                    case 1: {
                        if (target instanceof IResource) {
                            AccessRuleSet accessRuleSet;
                            IResource resource = (IResource)target;
                            ClasspathLocation bLocation = null;
                            if (resource instanceof IFile) {
                                accessRuleSet = "ignore".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                                bLocation = ClasspathLocation.forLibrary((IFile)resource, accessRuleSet, externalAnnotationPath, isOnModulePath);
                            } else if (resource instanceof IContainer) {
                                accessRuleSet = "ignore".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                                bLocation = ClasspathLocation.forBinaryFolder((IContainer)target, false, accessRuleSet, externalAnnotationPath, isOnModulePath);
                            }
                            bLocations.add(bLocation);
                            if (moduleEntries != null) {
                                patchedModule = this.collectModuleEntries(bLocation, path, isOnModulePath, limitModules, patchedModuleName, patchedModule, moduleEntries);
                            }
                            if (binaryLocationsPerProject == null) break;
                            IProject p = resource.getProject();
                            ClasspathLocation[] existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get(p);
                            if (existingLocations == null) {
                                existingLocations = new ClasspathLocation[]{bLocation};
                            } else {
                                int size = existingLocations.length;
                                ClasspathLocation[] classpathLocationArray = existingLocations;
                                existingLocations = new ClasspathLocation[size + 1];
                                System.arraycopy(classpathLocationArray, 0, existingLocations, 0, size);
                                existingLocations[size] = bLocation;
                            }
                            binaryLocationsPerProject.put(p, existingLocations);
                            break;
                        }
                        if (!(target instanceof File)) break;
                        AccessRuleSet accessRuleSet = "ignore".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) && "ignore".equals(javaProject.getOption("orika_shaded.org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) ? null : entry.getAccessRuleSet();
                        ClasspathLocation bLocation = ClasspathLocation.forLibrary(path.toOSString(), accessRuleSet, externalAnnotationPath, isOnModulePath);
                        bLocations.add(bLocation);
                        if (moduleEntries == null) break;
                        Set<String> libraryLimitModules = limitModules == null && projectModule != null ? ClasspathJrt.NO_LIMIT_MODULES : limitModules;
                        patchedModule = this.collectModuleEntries(bLocation, path, isOnModulePath, libraryLimitModules, patchedModuleName, patchedModule, moduleEntries);
                    }
                }
            }
            ++i;
        }
        ArrayList<ClasspathMultiDirectory> outputFolders = new ArrayList<ClasspathMultiDirectory>(1);
        this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
        if (!sLocations.isEmpty()) {
            sLocations.toArray(this.sourceLocations);
            if (moduleEntries != null && projectModule != null) {
                try {
                    AbstractModule sourceModule = (AbstractModule)projectModule;
                    ModuleDescriptionInfo info = (ModuleDescriptionInfo)sourceModule.getElementInfo();
                    ModulePathEntry projectEntry = new ModulePathEntry(javaProject.getPath(), info, this.sourceLocations);
                    if (!moduleEntries.containsKey(sourceModule.getElementName())) {
                        moduleEntries.put(sourceModule.getElementName(), projectEntry);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            int i2 = 0;
            int l2 = this.sourceLocations.length;
            while (i2 < l2) {
                block47: {
                    ClasspathMultiDirectory md = this.sourceLocations[i2];
                    IPath outputPath = md.binaryFolder.getFullPath();
                    int j = 0;
                    while (j < i2) {
                        if (outputPath.equals(this.sourceLocations[j].binaryFolder.getFullPath())) {
                            md.hasIndependentOutputFolder = this.sourceLocations[j].hasIndependentOutputFolder;
                            break block47;
                        }
                        ++j;
                    }
                    outputFolders.add(md);
                    j = 0;
                    int m = this.sourceLocations.length;
                    while (j < m) {
                        if (!outputPath.equals(this.sourceLocations[j].sourceFolder.getFullPath())) {
                            ++j;
                            continue;
                        }
                        break block47;
                    }
                    md.hasIndependentOutputFolder = true;
                }
                ++i2;
            }
        }
        this.binaryLocations = new ClasspathLocation[outputFolders.size() + bLocations.size()];
        int index = 0;
        int i3 = 0;
        int l3 = outputFolders.size();
        while (i3 < l3) {
            this.binaryLocations[index++] = (ClasspathLocation)outputFolders.get(i3);
            ++i3;
        }
        i3 = 0;
        l3 = bLocations.size();
        while (i3 < l3) {
            this.binaryLocations[index++] = (ClasspathLocation)bLocations.get(i3);
            ++i3;
        }
        if (moduleEntries != null && !moduleEntries.isEmpty()) {
            this.modulePathEntries = moduleEntries;
        }
    }

    IModule collectModuleEntries(ClasspathLocation bLocation, IPath path, boolean isOnModulePath, Set<String> limitModules, String patchedModuleName, IModule patchedModule, Map<String, IModulePathEntry> moduleEntries) {
        ModulePathEntry binaryModulePathEntry;
        IModule module;
        if (bLocation instanceof IMultiModuleEntry) {
            IModule module2;
            IMultiModuleEntry binaryModulePathEntry2 = (IMultiModuleEntry)((Object)bLocation);
            for (String moduleName : binaryModulePathEntry2.getModuleNames(limitModules)) {
                moduleEntries.put(moduleName, binaryModulePathEntry2);
            }
            if (patchedModuleName != null && (module2 = binaryModulePathEntry2.getModule(patchedModuleName.toCharArray())) != null) {
                return module2;
            }
        } else if (isOnModulePath && (module = (binaryModulePathEntry = new ModulePathEntry(path, bLocation)).getModule()) != null) {
            String moduleName = String.valueOf(module.name());
            if (limitModules == null || limitModules == ClasspathJrt.NO_LIMIT_MODULES || limitModules.contains(moduleName)) {
                moduleEntries.put(moduleName, binaryModulePathEntry);
                if (patchedModuleName != null && moduleName.equals(patchedModuleName)) {
                    return module;
                }
            }
        }
        return patchedModule;
    }

    protected boolean isOnModulePath(ClasspathEntry entry) {
        return entry.isModular();
    }

    @Override
    public void cleanup() {
        this.initialTypeNames = null;
        this.additionalUnits = null;
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].cleanup();
            ++i;
        }
        i = 0;
        l = this.binaryLocations.length;
        while (i < l) {
            this.binaryLocations[i].cleanup();
            ++i;
        }
    }

    private void createOutputFolder(IContainer outputFolder) throws CoreException {
        this.createParentFolder(outputFolder.getParent());
        ((IFolder)outputFolder).create(1025, true, null);
    }

    private void createParentFolder(IContainer parent) throws CoreException {
        if (!parent.exists()) {
            this.createParentFolder(parent.getParent());
            ((IFolder)parent).create(true, true, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName, IModuleAwareNameEnvironment.LookupStrategy strategy, String moduleName) {
        ClasspathLocation[] relevantLocations;
        char[] binaryFileName;
        String qPackageName;
        String qBinaryFileName;
        block16: {
            String moduleQualifiedName;
            if (this.notifier != null) {
                this.notifier.checkCancelWithinCompiler();
            }
            String string = moduleQualifiedName = moduleName != null ? String.valueOf(moduleName) + ':' + qualifiedTypeName : qualifiedTypeName;
            if (this.initialTypeNames != null && this.initialTypeNames.includes(moduleQualifiedName)) {
                if (this.isIncrementalBuild) {
                    throw new AbortCompilation(true, new AbortIncrementalBuildException(qualifiedTypeName));
                }
                return null;
            }
            if (this.additionalUnits != null && this.sourceLocations.length > 0) {
                String enclosingTypeName;
                SourceFile unit = (SourceFile)this.additionalUnits.get(qualifiedTypeName);
                if (unit != null) {
                    return new NameEnvironmentAnswer(unit, null);
                }
                int index = qualifiedTypeName.indexOf(36);
                if (index > 0 && (unit = (SourceFile)this.additionalUnits.get(enclosingTypeName = qualifiedTypeName.substring(0, index))) != null) {
                    return new NameEnvironmentAnswer(unit, null);
                }
            }
            qBinaryFileName = String.valueOf(qualifiedTypeName) + ".class";
            qPackageName = qualifiedTypeName.length() == typeName.length ? Util.EMPTY_STRING : qBinaryFileName.substring(0, qBinaryFileName.length() - typeName.length - 7);
            binaryFileName = CharOperation.concat(typeName, SUFFIX_class);
            if (moduleName != null && this.modulePathEntries != null) {
                IModulePathEntry modulePathEntry = this.modulePathEntries.get(moduleName);
                if (modulePathEntry instanceof ModulePathEntry) {
                    relevantLocations = ((ModulePathEntry)modulePathEntry).getClasspathLocations();
                    break block16;
                } else {
                    if (modulePathEntry instanceof ClasspathLocation) {
                        return ((ClasspathLocation)((Object)modulePathEntry)).findClass(typeName, qPackageName, moduleName, qBinaryFileName, false);
                    }
                    return null;
                }
            }
            relevantLocations = this.binaryLocations;
        }
        NameEnvironmentAnswer suggestedAnswer = null;
        ClasspathLocation[] classpathLocationArray = relevantLocations;
        int n = relevantLocations.length;
        int n2 = 0;
        while (n2 < n) {
            char[] answerMod;
            NameEnvironmentAnswer answer;
            ClasspathLocation classpathLocation = classpathLocationArray[n2];
            if (strategy.matches(classpathLocation, ClasspathLocation::hasModule) && (answer = classpathLocation.findClass(binaryFileName, qPackageName, moduleName, qBinaryFileName, false)) != null && ((answerMod = answer.moduleName()) == null || this.modulePathEntries == null || this.modulePathEntries.containsKey(String.valueOf(answerMod)))) {
                if (!answer.ignoreIfBetter()) {
                    if (answer.isBetter(suggestedAnswer)) {
                        return answer;
                    }
                } else if (answer.isBetter(suggestedAnswer)) {
                    suggestedAnswer = answer;
                }
            }
            ++n2;
        }
        return suggestedAnswer;
    }

    @Override
    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        if (compoundName != null) {
            return this.findClass(String.valueOf(CharOperation.concatWith(compoundName, '/')), compoundName[compoundName.length - 1], IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
        }
        return null;
    }

    @Override
    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        return this.findClass(String.valueOf(CharOperation.concatWith(packageName, typeName, '/')), typeName, IModuleAwareNameEnvironment.LookupStrategy.get(moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName));
    }

    @Override
    public char[][] getModulesDeclaringPackage(char[][] parentPackageName, char[] name, char[] moduleName) {
        String pkgName = new String(CharOperation.concatWith(parentPackageName, name, '/'));
        String modName = new String(moduleName);
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        switch (strategy) {
            case Any: 
            case Unnamed: {
                char[][] declaringModules;
                ClasspathLocation location;
                char[][] names = CharOperation.NO_CHAR_CHAR;
                ClasspathLocation[] classpathLocationArray = this.binaryLocations;
                int n = this.binaryLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches(location, ClasspathLocation::hasModule) && (declaringModules = location.getModulesDeclaringPackage(pkgName, null)) != null) {
                        names = CharOperation.arrayConcat(names, declaringModules);
                    }
                    ++n2;
                }
                classpathLocationArray = this.sourceLocations;
                n = this.sourceLocations.length;
                n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches(location, ClasspathLocation::hasModule) && (declaringModules = location.getModulesDeclaringPackage(pkgName, null)) != null) {
                        names = CharOperation.arrayConcat(names, declaringModules);
                    }
                    ++n2;
                }
                return names == CharOperation.NO_CHAR_CHAR ? null : names;
            }
            case AnyNamed: {
                modName = null;
            }
        }
        if (this.modulePathEntries != null) {
            char[][] names = CharOperation.NO_CHAR_CHAR;
            for (IModulePathEntry modulePathEntry : this.modulePathEntries.values()) {
                char[][] declaringModules = modulePathEntry.getModulesDeclaringPackage(pkgName, modName);
                if (declaringModules == null) continue;
                names = CharOperation.arrayConcat(names, declaringModules);
            }
            return names == CharOperation.NO_CHAR_CHAR ? null : names;
        }
        return null;
    }

    @Override
    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        String pkgName = String.valueOf(CharOperation.concatWith(qualifiedPackageName, '/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        String modName = IModuleAwareNameEnvironment.LookupStrategy.getStringName(moduleName);
        switch (strategy) {
            case Any: 
            case Unnamed: {
                ClasspathLocation location;
                ClasspathLocation[] classpathLocationArray = this.binaryLocations;
                int n = this.binaryLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches(location, ClasspathLocation::hasModule) && location.hasCompilationUnit(pkgName, null)) {
                        return true;
                    }
                    ++n2;
                }
                classpathLocationArray = this.sourceLocations;
                n = this.sourceLocations.length;
                n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches(location, ClasspathLocation::hasModule) && location.hasCompilationUnit(pkgName, null)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            case Named: {
                if (this.modulePathEntries != null) {
                    IModulePathEntry modulePathEntry = this.modulePathEntries.get(modName);
                    return modulePathEntry != null && modulePathEntry.hasCompilationUnit(pkgName, modName);
                }
                return false;
            }
            case AnyNamed: {
                if (this.modulePathEntries != null) {
                    for (IModulePathEntry modulePathEntry : this.modulePathEntries.values()) {
                        if (!modulePathEntry.hasCompilationUnit(pkgName, modName)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + (Object)((Object)strategy));
    }

    public boolean isPackage(String qualifiedPackageName, char[] moduleName) {
        String stringModuleName = null;
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get(moduleName);
        Collection<IModulePathEntry> entries = null;
        switch (strategy) {
            case Any: 
            case Unnamed: {
                int i = 0;
                int l = this.binaryLocations.length;
                while (i < l) {
                    if (strategy.matches(this.binaryLocations[i], ClasspathLocation::hasModule) && this.binaryLocations[i].isPackage(qualifiedPackageName, null)) {
                        return true;
                    }
                    ++i;
                }
                i = 0;
                l = this.sourceLocations.length;
                while (i < l) {
                    if (strategy.matches(this.sourceLocations[i], ClasspathLocation::hasModule) && this.sourceLocations[i].isPackage(qualifiedPackageName, null)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case AnyNamed: {
                entries = this.modulePathEntries.values();
                break;
            }
            default: {
                stringModuleName = String.valueOf(moduleName);
                IModulePathEntry entry = this.modulePathEntries.get(stringModuleName);
                if (entry == null) {
                    return false;
                }
                entries = Collections.singletonList(entry);
            }
        }
        for (IModulePathEntry modulePathEntry : entries) {
            if (modulePathEntry instanceof ModulePathEntry) {
                ClasspathLocation[] classpathLocationArray = ((ModulePathEntry)modulePathEntry).getClasspathLocations();
                int n = classpathLocationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClasspathLocation classpathLocation = classpathLocationArray[n2];
                    if (classpathLocation.isPackage(qualifiedPackageName, stringModuleName)) {
                        return true;
                    }
                    ++n2;
                }
                continue;
            }
            if (!(modulePathEntry instanceof ClasspathLocation)) continue;
            return ((ClasspathLocation)((Object)modulePathEntry)).isPackage(qualifiedPackageName, stringModuleName);
        }
        return false;
    }

    void setNames(String[] typeNames, SourceFile[] additionalFiles) {
        int l;
        int i;
        if (typeNames == null) {
            this.initialTypeNames = null;
        } else {
            this.initialTypeNames = new SimpleSet(typeNames.length);
            i = 0;
            l = typeNames.length;
            while (i < l) {
                this.initialTypeNames.add(typeNames[i]);
                ++i;
            }
        }
        if (additionalFiles == null) {
            this.additionalUnits = null;
        } else {
            this.additionalUnits = new SimpleLookupTable(additionalFiles.length);
            i = 0;
            l = additionalFiles.length;
            while (i < l) {
                SourceFile additionalUnit = additionalFiles[i];
                if (additionalUnit != null) {
                    this.additionalUnits.put(additionalUnit.initialTypeName, additionalFiles[i]);
                }
                ++i;
            }
        }
        i = 0;
        l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].reset();
            ++i;
        }
        i = 0;
        l = this.binaryLocations.length;
        while (i < l) {
            this.binaryLocations[i].reset();
            ++i;
        }
    }

    @Override
    public IModule getModule(char[] name) {
        if (this.modulePathEntries != null) {
            IModulePathEntry modulePathEntry = this.modulePathEntries.get(String.valueOf(name));
            if (modulePathEntry instanceof IMultiModuleEntry) {
                return modulePathEntry.getModule(name);
            }
            if (modulePathEntry != null) {
                return modulePathEntry.getModule();
            }
        }
        return null;
    }

    @Override
    public char[][] getAllAutomaticModules() {
        if (this.modulePathEntries == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Set set = this.modulePathEntries.values().stream().filter(m -> m.isAutomaticModule()).map(e -> e.getModule().name()).collect(Collectors.toSet());
        return (char[][])set.toArray((T[])new char[set.size()][]);
    }

    @Override
    public void applyModuleUpdates(IUpdatableModule compilerModule, IUpdatableModule.UpdateKind kind) {
        if (this.moduleUpdater != null) {
            this.moduleUpdater.applyModuleUpdates(compilerModule, kind);
        }
    }
}

