/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.dom.rewrite;

import java.util.ArrayList;
import orika_shaded.org.eclipse.jdt.core.formatter.IndentManipulation;
import orika_shaded.org.eclipse.text.edits.ISourceModifier;
import orika_shaded.org.eclipse.text.edits.ReplaceEdit;

public class SourceModifier
implements ISourceModifier {
    private final String destinationIndent;
    private final int sourceIndentLevel;
    private final int tabWidth;
    private final int indentWidth;

    public SourceModifier(int sourceIndentLevel, String destinationIndent, int tabWidth, int indentWidth) {
        this.destinationIndent = destinationIndent;
        this.sourceIndentLevel = sourceIndentLevel;
        this.tabWidth = tabWidth;
        this.indentWidth = indentWidth;
    }

    @Override
    public ISourceModifier copy() {
        return this;
    }

    @Override
    public ReplaceEdit[] getModifications(String source) {
        ArrayList result = new ArrayList();
        int destIndentLevel = IndentManipulation.measureIndentUnits(this.destinationIndent, this.tabWidth, this.indentWidth);
        if (destIndentLevel == this.sourceIndentLevel) {
            return result.toArray(new ReplaceEdit[result.size()]);
        }
        return IndentManipulation.getChangeIndentEdits(source, this.sourceIndentLevel, this.tabWidth, this.indentWidth, this.destinationIndent);
    }
}

