/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.nd;

import java.util.function.Supplier;
import orika_shaded.org.eclipse.jdt.internal.core.nd.IReader;
import orika_shaded.org.eclipse.jdt.internal.core.nd.Nd;
import orika_shaded.org.eclipse.jdt.internal.core.nd.NdNode;

public class DatabaseRef<T extends NdNode>
implements Supplier<T> {
    private final Nd nd;
    private T lastResult;
    private long writeCounter;
    private final Supplier<T> searchFunction;

    public DatabaseRef(Nd nd, Supplier<T> searchFunction) {
        this.nd = nd;
        this.searchFunction = searchFunction;
        this.writeCounter = -1L;
    }

    public DatabaseRef(Nd nd, Supplier<T> searchFunction, T initialResult) {
        this.nd = nd;
        this.searchFunction = searchFunction;
        this.lastResult = initialResult;
        this.writeCounter = this.nd.getWriteNumber();
    }

    @Override
    public T get() {
        long ndWriteNumber = this.nd.getWriteNumber();
        if (this.writeCounter == ndWriteNumber) {
            return this.lastResult;
        }
        NdNode result = (NdNode)this.searchFunction.get();
        this.writeCounter = ndWriteNumber;
        this.lastResult = result;
        return (T)result;
    }

    public Nd getNd() {
        return this.nd;
    }

    public IReader lock() {
        return this.nd.acquireReadLock();
    }
}

