/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.nd.db;

import orika_shaded.org.eclipse.core.runtime.preferences.IEclipsePreferences;
import orika_shaded.org.eclipse.core.runtime.preferences.InstanceScope;
import orika_shaded.org.eclipse.jdt.internal.core.nd.db.Chunk;

public final class ChunkCache {
    private static ChunkCache sSharedInstance;
    private Chunk[] fPageTable;
    private boolean fTableIsFull;
    private int fPointer;
    public static final String CHUNK_CACHE_SIZE_MB = "chunkCacheSizeMb";
    public static final String CHUNK_CACHE_SIZE_PERCENT = "chunkCacheSizePercent";
    public static final double CHUNK_CACHE_SIZE_MB_DEFAULT = 128.0;
    public static final double CHUNK_CACHE_SIZE_PERCENT_DEFAULT = 5.0;

    static {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("orika_shaded.org.eclipse.jdt.core");
        long chunkSize = ChunkCache.getChunkCacheSize(node);
        sSharedInstance = new ChunkCache(chunkSize);
        node.addPreferenceChangeListener(event -> {
            String key = event.getKey();
            if (key.equals(CHUNK_CACHE_SIZE_MB) | key.equals(CHUNK_CACHE_SIZE_PERCENT)) {
                sSharedInstance.setMaxSize(ChunkCache.getChunkCacheSize(node));
            }
        });
    }

    private static long getChunkCacheSize(IEclipsePreferences node) {
        double maxSizeMb = node.getDouble(CHUNK_CACHE_SIZE_MB, 128.0);
        double maxSizePercent = node.getDouble(CHUNK_CACHE_SIZE_PERCENT, 5.0);
        maxSizePercent = Math.max(1.0, Math.min(50.0, maxSizePercent));
        maxSizeMb = Math.max(maxSizeMb, 1.0);
        long m1 = (long)((double)Runtime.getRuntime().maxMemory() / 100.0 * maxSizePercent);
        return Math.min(m1, (long)(maxSizeMb * 1024.0 * 1024.0));
    }

    public static ChunkCache getSharedInstance() {
        return sSharedInstance;
    }

    public ChunkCache() {
        this(0x500000L);
    }

    public ChunkCache(long maxSize) {
        this.fPageTable = new Chunk[this.computeLength(maxSize)];
    }

    public synchronized void add(Chunk chunk) {
        if (chunk.fCacheIndex >= 0) {
            chunk.fCacheHitFlag = true;
            return;
        }
        if (this.fTableIsFull) {
            this.evictChunk();
            chunk.fCacheIndex = this.fPointer;
            this.fPageTable[this.fPointer] = chunk;
        } else {
            chunk.fCacheIndex = this.fPointer;
            this.fPageTable[this.fPointer] = chunk;
            ++this.fPointer;
            if (this.fPointer == this.fPageTable.length) {
                this.fPointer = 0;
                this.fTableIsFull = true;
            }
        }
    }

    private void evictChunk() {
        Chunk chunk;
        while (true) {
            chunk = this.fPageTable[this.fPointer];
            if (!chunk.fCacheHitFlag) break;
            chunk.fCacheHitFlag = false;
            this.fPointer = (this.fPointer + 1) % this.fPageTable.length;
        }
        chunk.fCacheIndex = -1;
        chunk.fDatabase.checkIfChunkReleased(chunk);
        this.fPageTable[this.fPointer] = null;
    }

    public synchronized void remove(Chunk chunk) {
        int idx = chunk.fCacheIndex;
        if (idx >= 0) {
            Chunk move;
            if (this.fTableIsFull) {
                this.fPointer = this.fPageTable.length - 1;
                this.fTableIsFull = false;
            } else {
                --this.fPointer;
            }
            chunk.fCacheIndex = -1;
            this.fPageTable[idx] = move = this.fPageTable[this.fPointer];
            move.fCacheIndex = idx;
            this.fPageTable[this.fPointer] = null;
        }
    }

    public synchronized long getMaxSize() {
        return (long)this.fPageTable.length * 4096L;
    }

    public synchronized void setMaxSize(long maxSize) {
        int oldLength;
        int newLength = this.computeLength(maxSize);
        int n = oldLength = this.fTableIsFull ? this.fPageTable.length : this.fPointer;
        if (newLength > oldLength) {
            Chunk[] newTable = new Chunk[newLength];
            System.arraycopy(this.fPageTable, 0, newTable, 0, oldLength);
            this.fTableIsFull = false;
            this.fPointer = oldLength;
            this.fPageTable = newTable;
        } else {
            int i = newLength;
            while (i < oldLength) {
                Chunk chunk = this.fPageTable[i];
                chunk.fCacheIndex = -1;
                chunk.fDatabase.checkIfChunkReleased(chunk);
                ++i;
            }
            Chunk[] newTable = new Chunk[newLength];
            System.arraycopy(this.fPageTable, 0, newTable, 0, newLength);
            this.fTableIsFull = true;
            this.fPointer = 0;
            this.fPageTable = newTable;
        }
    }

    private int computeLength(long maxSize) {
        long maxLength = Math.min(maxSize / 4096L, Integer.MAX_VALUE);
        return Math.max(1, (int)maxLength);
    }

    public synchronized void clear() {
        int i = 0;
        while (i < this.fPageTable.length) {
            Chunk chunk = this.fPageTable[i];
            if (chunk != null) {
                chunk.fCacheIndex = -1;
                chunk.fDatabase.checkIfChunkReleased(chunk);
                this.fPageTable[i] = null;
            }
            ++i;
        }
        this.fTableIsFull = false;
        this.fPointer = 0;
    }
}

