/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.nd.field;

import orika_shaded.org.eclipse.jdt.internal.core.nd.Nd;
import orika_shaded.org.eclipse.jdt.internal.core.nd.db.Database;
import orika_shaded.org.eclipse.jdt.internal.core.nd.db.ModificationLog;
import orika_shaded.org.eclipse.jdt.internal.core.nd.field.BaseField;

public class FieldInt
extends BaseField {
    private final ModificationLog.Tag tag;

    public FieldInt(String structName, int fieldNumber) {
        this.setFieldName("field " + fieldNumber + ", a " + this.getClass().getSimpleName() + " in struct " + structName);
        this.tag = ModificationLog.createTag("Writing " + this.getFieldName());
    }

    public int get(Nd nd, long address) {
        Database db = nd.getDB();
        return db.getInt(address + (long)this.offset);
    }

    public void put(Nd nd, long address, int newValue) {
        Database db = nd.getDB();
        db.getLog().start(this.tag);
        try {
            nd.getDB().putInt(address + (long)this.offset, newValue);
        }
        finally {
            db.getLog().end(this.tag);
        }
    }

    @Override
    public int getRecordSize() {
        return 4;
    }
}

