/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.search;

import java.io.EOFException;
import java.io.IOException;
import orika_shaded.org.eclipse.core.runtime.IPath;
import orika_shaded.org.eclipse.core.runtime.IProgressMonitor;
import orika_shaded.org.eclipse.core.runtime.OperationCanceledException;
import orika_shaded.org.eclipse.core.runtime.SubMonitor;
import orika_shaded.org.eclipse.jdt.core.search.IJavaSearchScope;
import orika_shaded.org.eclipse.jdt.core.search.SearchParticipant;
import orika_shaded.org.eclipse.jdt.core.search.SearchPattern;
import orika_shaded.org.eclipse.jdt.internal.core.JavaModelManager;
import orika_shaded.org.eclipse.jdt.internal.core.index.FileIndexLocation;
import orika_shaded.org.eclipse.jdt.internal.core.index.Index;
import orika_shaded.org.eclipse.jdt.internal.core.index.IndexLocation;
import orika_shaded.org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import orika_shaded.org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import orika_shaded.org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import orika_shaded.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import orika_shaded.org.eclipse.jdt.internal.core.search.processing.IJob;
import orika_shaded.org.eclipse.jdt.internal.core.search.processing.JobManager;
import orika_shaded.org.eclipse.jdt.internal.core.util.Util;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected SearchParticipant participant;
    protected IndexQueryRequestor requestor;
    protected boolean areIndexesReady;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, SearchParticipant participant, IJavaSearchScope scope, IndexQueryRequestor requestor) {
        this.pattern = pattern;
        this.participant = participant;
        this.scope = scope;
        this.requestor = requestor;
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return true;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void ensureReadyToRun() {
        if (!this.areIndexesReady) {
            this.getIndexes(null);
        }
    }

    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert(progressMonitor, 3);
        boolean isComplete = true;
        this.executionTime = 0L;
        Index[] indexes = this.getIndexes(subMonitor.split(1));
        try {
            int max = indexes.length;
            SubMonitor loopMonitor = subMonitor.split(2).setWorkRemaining(max);
            int i = 0;
            while (i < max) {
                isComplete &= this.search(indexes[i], loopMonitor.split(1));
                ++i;
            }
            if (JobManager.VERBOSE) {
                Util.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            boolean bl = isComplete;
            return bl;
        }
        finally {
            SubMonitor.done(progressMonitor);
        }
    }

    public Index[] getIndexes(IProgressMonitor progressMonitor) {
        int length;
        IndexLocation[] indexLocations;
        if (this.participant instanceof JavaSearchParticipant) {
            indexLocations = ((JavaSearchParticipant)this.participant).selectIndexURLs(this.pattern, this.scope);
            length = indexLocations.length;
        } else {
            IPath[] paths = this.participant.selectIndexes(this.pattern, this.scope);
            length = paths.length;
            indexLocations = new IndexLocation[paths.length];
            int i = 0;
            int len = paths.length;
            while (i < len) {
                indexLocations[i] = new FileIndexLocation(paths[i].toFile(), true);
                ++i;
            }
        }
        Index[] indexes = JavaModelManager.getIndexManager().getIndexes(indexLocations, progressMonitor);
        this.areIndexesReady = indexes.length == length;
        return indexes;
    }

    @Override
    public boolean waitNeeded() {
        return true;
    }

    @Override
    public String getJobFamily() {
        return "";
    }

    public boolean search(Index index, IProgressMonitor progressMonitor) {
        if (index == null) {
            return true;
        }
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            monitor.enterRead();
            long start = System.currentTimeMillis();
            MatchLocator.findIndexMatches(this.pattern, index, this.requestor, this.participant, this.scope, progressMonitor);
            this.executionTime += System.currentTimeMillis() - start;
            return true;
        }
        catch (IOException e) {
            if (e instanceof EOFException) {
                e.printStackTrace();
            }
            return false;
        }
        finally {
            monitor.exitRead();
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

