/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.jdt.internal.core.search.matching;

import orika_shaded.org.eclipse.core.runtime.CoreException;
import orika_shaded.org.eclipse.jdt.core.IJavaElement;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.LambdaExpression;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import orika_shaded.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.Binding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import orika_shaded.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import orika_shaded.org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import orika_shaded.org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import orika_shaded.org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import orika_shaded.org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;

public class SuperTypeReferenceLocator
extends PatternLocator {
    protected SuperTypeReferencePattern pattern;

    public SuperTypeReferenceLocator(SuperTypeReferencePattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    public int match(LambdaExpression node, MatchingNodeSet nodeSet) {
        if (this.pattern.superRefKind != 1) {
            return 0;
        }
        nodeSet.mustResolve = true;
        return nodeSet.addMatch(node, 2);
    }

    @Override
    public int match(TypeReference node, MatchingNodeSet nodeSet) {
        if (this.flavors != 4096) {
            return 0;
        }
        if (this.pattern.superSimpleName == null) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        char[] typeRefSimpleName = null;
        if (node instanceof SingleTypeReference) {
            typeRefSimpleName = ((SingleTypeReference)node).token;
        } else {
            char[][] tokens = ((QualifiedTypeReference)node).tokens;
            typeRefSimpleName = tokens[tokens.length - 1];
        }
        if (this.matchesName(this.pattern.superSimpleName, typeRefSimpleName)) {
            return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
        }
        return 0;
    }

    @Override
    protected int matchContainer() {
        return 2;
    }

    @Override
    protected void matchReportReference(ASTNode reference, IJavaElement element, Binding elementBinding, int accuracy, MatchLocator locator) throws CoreException {
        if (elementBinding instanceof ReferenceBinding) {
            ReferenceBinding referenceBinding = (ReferenceBinding)elementBinding;
            if (referenceBinding.isClass() && this.pattern.typeSuffix == 'I') {
                return;
            }
            if (referenceBinding.isInterface() && this.pattern.typeSuffix == 'C') {
                return;
            }
        }
        super.matchReportReference(reference, element, elementBinding, accuracy, locator);
    }

    @Override
    protected int referenceType() {
        return 7;
    }

    @Override
    public int resolveLevel(ASTNode node) {
        TypeBinding typeBinding = null;
        if (node instanceof LambdaExpression) {
            LambdaExpression lambda = (LambdaExpression)node;
            typeBinding = lambda.resolvedType;
        } else {
            if (!(node instanceof TypeReference)) {
                return 0;
            }
            TypeReference typeRef = (TypeReference)node;
            typeBinding = typeRef.resolvedType;
        }
        if (typeBinding instanceof ArrayBinding) {
            typeBinding = ((ArrayBinding)typeBinding).leafComponentType;
        }
        if (typeBinding instanceof ProblemReferenceBinding) {
            typeBinding = ((ProblemReferenceBinding)typeBinding).closestMatch();
        }
        if (typeBinding == null || !typeBinding.isValidBinding()) {
            return 1;
        }
        return this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, typeBinding);
    }

    @Override
    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof ReferenceBinding)) {
            return 0;
        }
        ReferenceBinding type = (ReferenceBinding)binding;
        int level = 0;
        if (this.pattern.superRefKind != 1 && (level = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, type.superclass())) == 3) {
            return 3;
        }
        if (this.pattern.superRefKind != 2) {
            ReferenceBinding[] superInterfaces = type.superInterfaces();
            int i = 0;
            int max = superInterfaces.length;
            while (i < max) {
                int newLevel = this.resolveLevelForType(this.pattern.superSimpleName, this.pattern.superQualification, superInterfaces[i]);
                if (newLevel > level) {
                    if (newLevel == 3) {
                        return 3;
                    }
                    level = newLevel;
                }
                ++i;
            }
        }
        return level;
    }

    @Override
    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

