/*
 * Decompiled with CFR 0.152.
 */
package orika_shaded.org.eclipse.text.edits;

import orika_shaded.org.eclipse.core.runtime.Assert;
import orika_shaded.org.eclipse.jface.text.BadLocationException;
import orika_shaded.org.eclipse.jface.text.IDocument;
import orika_shaded.org.eclipse.text.edits.TextEdit;
import orika_shaded.org.eclipse.text.edits.TextEditVisitor;

public final class ReplaceEdit
extends TextEdit {
    private String fText;

    public ReplaceEdit(int offset, int length, String text) {
        super(offset, length);
        Assert.isNotNull(text);
        this.fText = text;
    }

    private ReplaceEdit(ReplaceEdit other) {
        super(other);
        this.fText = other.fText;
    }

    public String getText() {
        return this.fText;
    }

    @Override
    protected TextEdit doCopy() {
        return new ReplaceEdit(this);
    }

    @Override
    protected void accept0(TextEditVisitor visitor) {
        boolean visitChildren = visitor.visit(this);
        if (visitChildren) {
            this.acceptChildren(visitor);
        }
    }

    @Override
    int performDocumentUpdating(IDocument document) throws BadLocationException {
        document.replace(this.getOffset(), this.getLength(), this.fText);
        this.fDelta = this.fText.length() - this.getLength();
        return this.fDelta;
    }

    @Override
    boolean deleteChildren() {
        return true;
    }

    @Override
    void internalToString(StringBuffer buffer, int indent) {
        super.internalToString(buffer, indent);
        buffer.append(" <<").append(this.fText);
    }
}

