/*
 * Decompiled with CFR 0.152.
 */
package ma.ju.fieldmask.core;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.text.StringsKt;
import ma.ju.fieldmask.core.BeanPaths;
import ma.ju.fieldmask.core.DefaultListModel;
import ma.ju.fieldmask.core.DefaultMapModel;
import ma.ju.fieldmask.core.FieldMask;
import ma.ju.fieldmask.core.FieldModel;
import ma.ju.fieldmask.core.FieldResolver;
import ma.ju.fieldmask.core.ListModel;
import ma.ju.fieldmask.core.MapModel;
import ma.ju.fieldmask.core.MaskOptions;
import ma.ju.fieldmask.core.ModelsKt;
import ma.ju.fieldmask.core.NullModel;
import ma.ju.fieldmask.core.Path;
import ma.ju.fieldmask.core.Segment;
import ma.ju.fieldmask.core.UnknownFieldMaskException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J7\u0010\u000e\u001a\u00020\u0004\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u0002H\u000f2\u0006\u0010\u0011\u001a\u0002H\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J-\u0010\u000e\u001a\u00020\u0004\"\b\b\u0000\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u0002H\u000f2\u0006\u0010\u0011\u001a\u0002H\u000f2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J4\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u00012\u0012\u0010\u001c\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0002\b\u00030\u001d2\u0006\u0010\n\u001a\u00020\u000bH\u0002J,\u0010\u001e\u001a\u00020\u00042\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u001f2\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010 2\u0006\u0010\n\u001a\u00020\u000bH\u0002J8\u0010!\u001a\u00020\u00042\u000e\u0010\u0010\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\"2\u0016\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010#2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010$\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002JL\u0010%\u001a&\u0012\u0004\u0012\u00020&\u0012\u001c\u0012\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030(\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001f0'0\"2\f\u0010)\u001a\b\u0012\u0002\b\u0003\u0018\u00010(2\b\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\b\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0015J\u001c\u0010+\u001a\u0006\u0012\u0002\b\u00030,2\b\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u000bJ*\u0010-\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010.2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030/2\u0006\u0010\n\u001a\u00020\u000bH\u0002J.\u00100\u001a\u00020\u00042\u0010\u0010*\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\"2\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u00101\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u00012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u00063"}, d2={"Lma/ju/fieldmask/core/BeanMask;", "", "()V", "addField", "", "field", "Lma/ju/fieldmask/core/Segment;", "value", "model", "Lma/ju/fieldmask/core/MapModel;", "context", "Lma/ju/fieldmask/core/BeanMask$Context;", "primitive", "", "apply", "T", "source", "target", "query", "", "options", "Lma/ju/fieldmask/core/MaskOptions;", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;Lma/ju/fieldmask/core/MaskOptions;)V", "(Ljava/lang/Object;Ljava/lang/Object;Lma/ju/fieldmask/core/BeanMask$Context;)V", "applyCached", "applyField", "sourceValue", "targetValue", "property", "Lkotlin/reflect/KProperty1;", "applyList", "", "", "applyMap", "", "", "applyPojo", "extractMethod", "Ljava/lang/reflect/Method;", "Lkotlin/Pair;", "Lma/ju/fieldmask/core/FieldResolver;", "resolver", "instance", "mask", "Lma/ju/fieldmask/core/FieldModel;", "visitList", "", "Lma/ju/fieldmask/core/ListModel;", "visitMap", "visitPojo", "Context", "fieldmask-core"})
public final class BeanMask {
    @NotNull
    public static final BeanMask INSTANCE;

    public final <T> void apply(@NotNull T source, @NotNull T target, @NotNull String query, @NotNull MaskOptions options) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.apply(source, target, new Context(FieldMask.Companion.matcherFor$default(FieldMask.Companion, query, null, 2, null), new Path(null, null, 3, null), options, null, null, 24, null));
    }

    public static /* synthetic */ void apply$default(BeanMask beanMask, Object object, Object object2, String string, MaskOptions maskOptions, int n, Object object3) {
        if ((n & 8) != 0) {
            maskOptions = new MaskOptions(false, null, null, null, 15, null);
        }
        beanMask.apply(object, object2, string, maskOptions);
    }

    public final <T> void apply(@NotNull T source, @NotNull T target, @NotNull Context context) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!source.getClass().isAssignableFrom(target.getClass())) {
            throw (Throwable)new IllegalArgumentException("source class: " + source.getClass() + " is not assignable from " + target.getClass());
        }
        this.applyPojo(source, target, context);
    }

    private final void applyField(Object sourceValue, Object targetValue, KProperty1<Object, ?> property, Context context) {
        Object source = property.get(sourceValue);
        Object target = property.get(targetValue);
        if (!(property instanceof KMutableProperty)) {
            return;
        }
        if (target == null || source == null || ModelsKt.isPrimitive(source)) {
            ((KMutableProperty)property).getSetter().call(new Object[]{targetValue, source});
            return;
        }
        Object object = source;
        if (object instanceof List) {
            List data = TypeIntrinsics.asMutableList((Object)target);
            this.applyList((List)source, data, context);
        } else if (object instanceof Map) {
            Map data = TypeIntrinsics.asMutableMap((Object)target);
            this.applyMap((Map)source, data, context);
        } else {
            this.applyPojo(source, target, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void applyList(List<?> source, List<Object> target, Context context) {
        if (source.isEmpty()) {
            target.clear();
            return;
        }
        boolean bl = false;
        for (Object srcValue : (Iterable)source) {
            void index;
            if (index < target.size()) {
                Object targetValue = target.get((int)index);
                if (srcValue == null || targetValue == null || ModelsKt.isPrimitive(srcValue)) {
                    target.set((int)index, srcValue);
                } else {
                    Object t = srcValue;
                    if (t instanceof List) {
                        this.applyList((List)srcValue, TypeIntrinsics.asMutableList((Object)targetValue), context);
                    } else if (t instanceof Map) {
                        this.applyMap((Map)srcValue, TypeIntrinsics.asMutableMap((Object)targetValue), context);
                    } else {
                        this.applyPojo(srcValue, targetValue, context);
                    }
                }
            } else {
                target.add(srcValue);
            }
            ++index;
        }
    }

    private final void applyMap(Map<?, ?> source, Map<Object, Object> target, Context context) {
        if (this.applyCached(source, context)) {
            return;
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            String field = String.valueOf(entry.getKey());
            Path m = context.matches(new Segment(field, null, 2, null));
            if (m.getPaths().isEmpty()) continue;
            Object sourceValue = entry.getValue();
            Object targetValue = target.get(field);
            if (targetValue == null || sourceValue == null || ModelsKt.isPrimitive(sourceValue)) {
                target.put(field, targetValue);
                continue;
            }
            this.apply(sourceValue, targetValue, context.withRoot(new Segment(field, null, 2, null)));
        }
    }

    private final boolean applyCached(Object source, Context context) {
        String cacheKey = source.getClass().getName() + ':' + source.hashCode();
        if (context.getProperties().containsKey(cacheKey)) {
            return true;
        }
        context.getProperties().put(cacheKey, true);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyPojo(Object source, Object target, Context context) {
        void $this$filterTo$iv$iv;
        if (this.applyCached(source, context)) {
            return;
        }
        Iterable $this$filter$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(source.getClass()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            KProperty1 it = (KProperty1)element$iv$iv;
            boolean bl2 = false;
            boolean accessible = ModelsKt.isFieldAccessible(it);
            if (context.getOptions().getPathOptions().getIncludePrivate()) {
                if (!accessible) {
                    KCallablesJvm.setAccessible((KCallable)((KCallable)it), (boolean)true);
                }
                bl = true;
            } else {
                bl = accessible;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List properties = (List)destination$iv$iv;
        for (KProperty1 property : properties) {
            KProperty1 p;
            if (property == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KProperty1<kotlin.Any?, *>");
            }
            Path m = context.matches(new Segment(p.getName(), null, 2, null));
            if (m.getPaths().isEmpty() || !(p instanceof KMutableProperty)) continue;
            this.applyField(source, target, p, context.withRoot(new Segment(p.getName(), null, 2, null)));
        }
    }

    @NotNull
    public final FieldModel<?> mask(@Nullable Object instance, @NotNull String query, @NotNull MaskOptions options) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return this.mask(instance, new Context(FieldMask.Companion.matcherFor$default(FieldMask.Companion, query, null, 2, null), new Path(null, null, 3, null), options, null, null, 24, null));
    }

    public static /* synthetic */ FieldModel mask$default(BeanMask beanMask, Object object, String string, MaskOptions maskOptions, int n, Object object2) {
        if ((n & 4) != 0) {
            maskOptions = new MaskOptions(false, null, null, null, 15, null);
        }
        return beanMask.mask(object, string, maskOptions);
    }

    @NotNull
    public final FieldModel<?> mask(@Nullable Object instance, @NotNull Context context) {
        FieldModel fieldModel;
        FieldModel<List<Object>> model;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (instance == null) {
            return new NullModel();
        }
        Object object = instance;
        if (object instanceof Iterable) {
            model = new DefaultListModel(null, 1, null);
            this.visitList((Iterable)instance, (ListModel<?>)model, context);
            fieldModel = model;
        } else if (object instanceof Map) {
            model = new DefaultMapModel(null, 1, null);
            this.visitMap((Map)instance, (MapModel)model, context);
            fieldModel = model;
        } else {
            model = new DefaultMapModel(null, 1, null);
            this.visitPojo(instance, (MapModel)model, context);
            fieldModel = model;
        }
        FieldModel data = fieldModel;
        object = context.getFutures();
        boolean bl = false;
        if (!object.isEmpty()) {
            context.getOptions().getFutureHandler().invoke(context.getFutures());
        }
        return data;
    }

    private final void visitList(Iterable<?> instance, ListModel<?> model, Context context) {
        if (instance == null) {
            return;
        }
        for (Object child : instance) {
            if (child == null || ModelsKt.isPrimitive(child)) {
                model.add(child);
                continue;
            }
            if (child instanceof Map) {
                this.visitMap((Map)child, model.createMap(), context);
                continue;
            }
            this.visitPojo(child, model.createMap(), context);
        }
    }

    private final void visitMap(Map<?, ?> instance, MapModel<?> model, Context context) {
        if (instance == null) {
            return;
        }
        for (Map.Entry<?, ?> entry : instance.entrySet()) {
            Object value;
            String field = String.valueOf(entry.getKey());
            Path m = context.matches(new Segment(field, null, 2, null));
            if (m.getPaths().isEmpty() || (value = entry.getValue()) == null) continue;
            this.addField((Segment)CollectionsKt.last(m.getPaths()), value, model, context, ModelsKt.isPrimitive(value));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void visitPojo(Object instance, MapModel<?> model, Context context) {
        Object value;
        void $this$sortedBy$iv;
        if (instance == null) {
            return;
        }
        Class<?> klass = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        Iterable $this$filter$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(instance.getClass()));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : iterable) {
            boolean bl;
            KProperty1 it = (KProperty1)element$iv$iv;
            boolean bl2 = false;
            boolean accessible = ModelsKt.isFieldAccessible(it);
            if (context.getOptions().getPathOptions().getIncludePrivate()) {
                if (!accessible) {
                    KCallablesJvm.setAccessible((KCallable)((KCallable)it), (boolean)true);
                }
                bl = true;
            } else {
                bl = accessible;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        List properties = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                KProperty1 it = (KProperty1)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (KProperty1)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        Map resolverMethods = this.extractMethod(context.getOptions().getResolversMap().get(klass), instance, context);
        if (context.getOptions().getValidateMasks()) {
            void $this$filterTo$iv$iv3;
            Collection<Path> collection;
            void $this$mapTo$iv$iv;
            boolean bl2 = false;
            List paths = new ArrayList();
            paths.addAll((Collection)BeanPaths.INSTANCE.paths(instance.getClass(), new BeanPaths.Context(null, context.getOptions().getPathOptions(), 1, null)));
            Iterable iterable2 = resolverMethods.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable2) {
                Method m = (Method)element$iv;
                boolean bl3 = false;
                String[] stringArray = new String[1];
                String string = m.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.name");
                stringArray[0] = string;
                paths.add(new Path(stringArray));
                String string2 = m.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"m.name");
                if (!StringsKt.startsWith$default((String)string2, (String)"get", (boolean)false, (int)2, null)) continue;
                String[] stringArray2 = new String[1];
                String string3 = m.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"m.name");
                stringArray2[0] = StringsKt.decapitalize((String)StringsKt.replaceFirst$default((String)string3, (String)"get", (String)"", (boolean)false, (int)4, null));
                paths.add(new Path(stringArray2));
            }
            Iterable iterable3 = resolverMethods.keySet();
            List list = paths;
            boolean $i$f$map = false;
            Iterable $i$f$filterTo22 = iterable3;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable3, (int)10));
            boolean $i$f$mapTo232 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Method accessible = (Method)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                String[] stringArray = new String[1];
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                stringArray[0] = string;
                Path path = new Path(stringArray);
                collection.add(path);
            }
            collection = (List)destination$iv$iv2;
            list.addAll((Collection)collection);
            FieldMask entry = new FieldMask(paths, null, 2, null);
            Iterable $this$filter$iv2 = context.getMask().withPrefix(context.getRoot(), true).values();
            boolean $i$f$filter2 = false;
            Iterable $i$f$mapTo232 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                Path it = (Path)element$iv$iv;
                boolean bl5 = false;
                if (!entry.matches(it).getPaths().isEmpty()) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List invalid = (List)destination$iv$iv3;
            $this$filter$iv2 = paths;
            $i$f$filter2 = false;
            if (!$this$filter$iv2.isEmpty()) {
                $this$filter$iv2 = invalid;
                $i$f$filter2 = false;
                if (!$this$filter$iv2.isEmpty()) {
                    throw (Throwable)new UnknownFieldMaskException(invalid, entry.values(), null, 4, null);
                }
            }
        }
        boolean bl6 = false;
        Set props = new LinkedHashSet();
        for (KProperty1 kProperty1 : properties) {
            Object bl422;
            int it232;
            Object v8;
            Iterable $this$filterTo$iv$iv422;
            KProperty1 p;
            if (kProperty1 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.reflect.KProperty1<kotlin.Any?, *>");
            }
            Path m = context.matches(new Segment(p.getName(), null, 2, null));
            if (m.getPaths().isEmpty()) continue;
            value = p.get(instance);
            Set methodNames = SetsKt.setOf((Object[])new String[]{p.getName(), "get" + p.getName(), "get" + StringsKt.capitalize((String)p.getName())});
            Object $this$filter$iv3 = resolverMethods;
            boolean $i$f$filter3 = false;
            Map element$iv$iv = $this$filter$iv3;
            Map destination$iv$iv232 = new LinkedHashMap();
            boolean $i$f$filterTo232 = false;
            Object object = $this$filterTo$iv$iv422;
            boolean bl7 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry it = element$iv$iv2 = iterator.next();
                boolean bl3 = false;
                if (!methodNames.contains(((Method)it.getKey()).getName())) continue;
                destination$iv$iv232.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            $this$filter$iv3 = destination$iv$iv232;
            $i$f$filter3 = false;
            $this$filterTo$iv$iv422 = $this$filter$iv3.entrySet();
            boolean destination$iv$iv232 = false;
            Iterator $i$f$filterTo232 = $this$filterTo$iv$iv422.iterator();
            if (!$i$f$filterTo232.hasNext()) {
                v8 = null;
            } else {
                object = $i$f$filterTo232.next();
                if (!$i$f$filterTo232.hasNext()) {
                    v8 = object;
                } else {
                    Map.Entry it232 = (Map.Entry)object;
                    boolean bl422 = false;
                    it232 = ((List)((Pair)it232.getValue()).getSecond()).size();
                    do {
                        bl422 = $i$f$filterTo232.next();
                        Map.Entry it332 = (Map.Entry)bl422;
                        boolean $i$a$-maxByOrNull-BeanMask$visitPojo$5 = false;
                        int it332 = ((List)((Pair)it332.getValue()).getSecond()).size();
                        if (it232 >= it332) continue;
                        object = bl422;
                        it232 = it332;
                    } while ($i$f$filterTo232.hasNext());
                    v8 = object;
                }
            }
            Map.Entry entry = v8;
            if (entry != null) {
                void method;
                $this$filter$iv3 = entry;
                $i$f$filter3 = false;
                boolean $this$filterTo$iv$iv422 = false;
                Object $dstr$method$args = $this$filter$iv3;
                boolean bl5 = false;
                object = $dstr$method$args;
                it232 = 0;
                bl422 = (Method)object.getKey();
                object = $dstr$method$args;
                it232 = 0;
                Pair args = (Pair)object.getValue();
                Collection $this$toTypedArray$iv = (Collection)args.getSecond();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
                if (objectArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                value = method.invoke(args.getFirst(), Arrays.copyOf(objectArray, objectArray.length));
            }
            if (value == null) continue;
            this.addField((Segment)CollectionsKt.last(m.getPaths()), value, model, context, ModelsKt.isPrimitive(value));
            props.add(((Segment)CollectionsKt.last(m.getPaths())).getValue());
        }
        Object p = resolverMethods;
        boolean m = false;
        for (Map.Entry entry : p.entrySet()) {
            void method;
            value = entry;
            boolean methodNames = false;
            p = (Method)value.getKey();
            value = entry;
            methodNames = false;
            Pair args = (Pair)value.getValue();
            String string = method.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
            Segment path = new Segment(string, null, 2, null);
            Path m2 = context.matches(path);
            if (props.contains(method.getName()) || m2.getPaths().isEmpty()) continue;
            Collection $this$toTypedArray$iv = (Collection)args.getSecond();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object value2 = method.invoke(args.getFirst(), Arrays.copyOf(objectArray, objectArray.length));
            if (value2 == null) continue;
            this.addField((Segment)CollectionsKt.last(m2.getPaths()), value2, model, context, ModelsKt.isPrimitive(value2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Method, Pair<FieldResolver<?>, List<Object>>> extractMethod(FieldResolver<?> resolver, Object instance, Context context) {
        boolean bl = false;
        Map resolverMethods = new LinkedHashMap();
        if (resolver == null) {
            return resolverMethods;
        }
        Map methods = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)CollectionsKt.listOf((Object[])new Class[]{resolver.dataType(), Context.class}), (Object)CollectionsKt.listOf((Object[])new Object[]{instance, context})), TuplesKt.to((Object)CollectionsKt.listOf(resolver.dataType()), (Object)CollectionsKt.listOf((Object)instance))});
        Object object = methods;
        boolean bl2 = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$mapTo$iv$iv;
            Method[] $this$map$iv;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl3 = false;
            object = (List)entry2.getKey();
            entry2 = entry;
            bl3 = false;
            List values = (List)entry2.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)resolver.getClass().getDeclaredMethods(), (String)"resolver.javaClass.declaredMethods");
            boolean $i$f$map = false;
            Method[] methodArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            void var17_23 = $this$mapTo$iv$iv;
            int n = ((void)var17_23).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var21_27 = item$iv$iv = var17_23[i];
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                void v0 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it");
                String string = v0.getName();
                collection.add(string);
            }
            for (String name : (List)destination$iv$iv) {
                try {
                    Method method;
                    void args;
                    Collection $this$toTypedArray$iv = (Collection)args;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    Class[] classArray = thisCollection$iv.toArray(new Class[0]);
                    if (classArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    Method method2 = method = resolver.getClass().getMethod(name, Arrays.copyOf(classArray, classArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"method");
                    resolverMethods.put(method2, new Pair(resolver, (Object)values));
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
        }
        return resolverMethods;
    }

    private final void addField(Segment field, Object value, MapModel<?> model, Context context, boolean primitive) {
        if (primitive) {
            model.add(field.getField(), value);
            return;
        }
        Object data = value;
        if (value instanceof CompletableFuture) {
            if (((CompletableFuture)value).isDone()) {
                Object t = ((CompletableFuture)value).get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"value.get()");
                data = t;
            } else {
                ((CompletableFuture)value).thenAccept(new Consumer<Object>(field, model, context){
                    final /* synthetic */ Segment $field;
                    final /* synthetic */ MapModel $model;
                    final /* synthetic */ Context $context;

                    public final void accept(Object it) {
                        Object object = it;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it");
                        BeanMask.access$addField(BeanMask.INSTANCE, this.$field, object, this.$model, this.$context, ModelsKt.isPrimitive(it));
                    }
                    {
                        this.$field = segment;
                        this.$model = mapModel;
                        this.$context = context;
                    }
                });
                context.getFutures().add((CompletableFuture<?>)value);
                return;
            }
        }
        if (ModelsKt.isPrimitive(data)) {
            model.add(field.getField(), data);
            return;
        }
        Context ctx = context.withRoot(new Segment(field.getValue(), null, 2, null));
        Object object = data;
        if (object instanceof Iterable) {
            this.visitList((Iterable)data, model.createList(field.getField()), ctx);
        } else if (object instanceof Map) {
            this.visitMap((Map)data, model.createMap(field.getField()), ctx);
        } else {
            this.visitPojo(data, model.createMap(field.getField()), ctx);
        }
    }

    private BeanMask() {
    }

    static {
        BeanMask beanMask;
        INSTANCE = beanMask = new BeanMask();
    }

    public static final /* synthetic */ void access$addField(BeanMask $this, Segment field, Object value, MapModel model, Context context, boolean primitive) {
        $this.addField(field, value, model, context, primitive);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0012\b\u0002\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u0012\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\u0013\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u00c6\u0003J\u0017\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fH\u00c6\u0003JS\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0012\b\u0002\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t2\u0016\b\u0002\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\fH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\u000e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020\rH\u00d6\u0001J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&R\u001b\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006)"}, d2={"Lma/ju/fieldmask/core/BeanMask$Context;", "", "mask", "Lma/ju/fieldmask/core/FieldMask;", "root", "Lma/ju/fieldmask/core/Path;", "options", "Lma/ju/fieldmask/core/MaskOptions;", "futures", "", "Ljava/util/concurrent/CompletableFuture;", "properties", "", "", "(Lma/ju/fieldmask/core/FieldMask;Lma/ju/fieldmask/core/Path;Lma/ju/fieldmask/core/MaskOptions;Ljava/util/List;Ljava/util/Map;)V", "getFutures", "()Ljava/util/List;", "getMask", "()Lma/ju/fieldmask/core/FieldMask;", "getOptions", "()Lma/ju/fieldmask/core/MaskOptions;", "getProperties", "()Ljava/util/Map;", "getRoot", "()Lma/ju/fieldmask/core/Path;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "matches", "path", "Lma/ju/fieldmask/core/Segment;", "toString", "withRoot", "fieldmask-core"})
    public static final class Context {
        @NotNull
        private final FieldMask mask;
        @NotNull
        private final Path root;
        @NotNull
        private final MaskOptions options;
        @NotNull
        private final List<CompletableFuture<?>> futures;
        @NotNull
        private final Map<String, Object> properties;

        @NotNull
        public final Path matches(@NotNull Segment path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.mask.matches(this.root.join(path));
        }

        @NotNull
        public final Context withRoot(@NotNull Segment path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return Context.copy$default(this, null, Path.copy$default(this.root, null, 1, null).join(path), null, null, null, 29, null);
        }

        @NotNull
        public final FieldMask getMask() {
            return this.mask;
        }

        @NotNull
        public final Path getRoot() {
            return this.root;
        }

        @NotNull
        public final MaskOptions getOptions() {
            return this.options;
        }

        @NotNull
        public final List<CompletableFuture<?>> getFutures() {
            return this.futures;
        }

        @NotNull
        public final Map<String, Object> getProperties() {
            return this.properties;
        }

        public Context(@NotNull FieldMask mask, @NotNull Path root, @NotNull MaskOptions options, @NotNull List<CompletableFuture<?>> futures, @NotNull Map<String, Object> properties) {
            Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(futures, (String)"futures");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            this.mask = mask;
            this.root = root;
            this.options = options;
            this.futures = futures;
            this.properties = properties;
        }

        public /* synthetic */ Context(FieldMask fieldMask, Path path, MaskOptions maskOptions, List list, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            boolean bl;
            if ((n & 2) != 0) {
                path = new Path(null, null, 3, null);
            }
            if ((n & 4) != 0) {
                maskOptions = new MaskOptions(false, null, null, null, 15, null);
            }
            if ((n & 8) != 0) {
                bl = false;
                list = new ArrayList();
            }
            if ((n & 0x10) != 0) {
                bl = false;
                map = new LinkedHashMap();
            }
            this(fieldMask, path, maskOptions, list, map);
        }

        @NotNull
        public final FieldMask component1() {
            return this.mask;
        }

        @NotNull
        public final Path component2() {
            return this.root;
        }

        @NotNull
        public final MaskOptions component3() {
            return this.options;
        }

        @NotNull
        public final List<CompletableFuture<?>> component4() {
            return this.futures;
        }

        @NotNull
        public final Map<String, Object> component5() {
            return this.properties;
        }

        @NotNull
        public final Context copy(@NotNull FieldMask mask, @NotNull Path root, @NotNull MaskOptions options, @NotNull List<CompletableFuture<?>> futures, @NotNull Map<String, Object> properties) {
            Intrinsics.checkNotNullParameter((Object)mask, (String)"mask");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(futures, (String)"futures");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            return new Context(mask, root, options, futures, properties);
        }

        public static /* synthetic */ Context copy$default(Context context, FieldMask fieldMask, Path path, MaskOptions maskOptions, List list, Map map, int n, Object object) {
            if ((n & 1) != 0) {
                fieldMask = context.mask;
            }
            if ((n & 2) != 0) {
                path = context.root;
            }
            if ((n & 4) != 0) {
                maskOptions = context.options;
            }
            if ((n & 8) != 0) {
                list = context.futures;
            }
            if ((n & 0x10) != 0) {
                map = context.properties;
            }
            return context.copy(fieldMask, path, maskOptions, list, map);
        }

        @NotNull
        public String toString() {
            return "Context(mask=" + this.mask + ", root=" + this.root + ", options=" + this.options + ", futures=" + this.futures + ", properties=" + this.properties + ")";
        }

        public int hashCode() {
            FieldMask fieldMask = this.mask;
            Path path = this.root;
            MaskOptions maskOptions = this.options;
            List<CompletableFuture<?>> list = this.futures;
            Map<String, Object> map = this.properties;
            return ((((fieldMask != null ? fieldMask.hashCode() : 0) * 31 + (path != null ? path.hashCode() : 0)) * 31 + (maskOptions != null ? ((Object)maskOptions).hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (map != null ? ((Object)map).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.mask, (Object)context.mask) || !Intrinsics.areEqual((Object)this.root, (Object)context.root) || !Intrinsics.areEqual((Object)this.options, (Object)context.options) || !Intrinsics.areEqual(this.futures, context.futures) || !Intrinsics.areEqual(this.properties, context.properties)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

