/*
 * Decompiled with CFR 0.152.
 */
package ma.ju.fieldmask.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import ma.ju.fieldmask.core.FieldsQueryListener;
import ma.ju.fieldmask.core.ParseException;
import ma.ju.fieldmask.core.Path;
import ma.ju.fieldmask.core.SyntaxErrorListener;
import ma.ju.fieldmask.grammar.FieldsGrammarLexer;
import ma.ju.fieldmask.grammar.FieldsGrammarParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lma/ju/fieldmask/core/FieldQueryParser;", "", "()V", "parse", "", "Lma/ju/fieldmask/core/Path;", "query", "", "separator", "Companion", "fieldmask-core"})
public final class FieldQueryParser {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<Path> parse(@NotNull String query, @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        FieldsGrammarParser parser = new FieldsGrammarParser((TokenStream)new CommonTokenStream((TokenSource)new FieldsGrammarLexer((CharStream)CharStreams.fromString((String)query))));
        SyntaxErrorListener errorListener = new SyntaxErrorListener(null, 1, null);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        FieldsGrammarParser.MainQContext tree = parser.mainQ();
        Collection collection = errorListener.getErrors();
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)new ParseException("error parsing fields [" + query + "]: " + CollectionsKt.joinToString$default((Iterable)errorListener.getErrors(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
        FieldsQueryListener extractor = new FieldsQueryListener(separator);
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)extractor, (ParseTree)tree);
        return extractor.fields();
    }

    public static /* synthetic */ List parse$default(FieldQueryParser fieldQueryParser, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "/";
        }
        return fieldQueryParser.parse(string, string2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lma/ju/fieldmask/core/FieldQueryParser$Companion;", "", "()V", "discardEscapeChar", "", "input", "hexToInt", "", "c", "", "fieldmask-core"})
    public static final class Companion {
        private final int hexToInt(char c) throws ParseException {
            int n;
            char c2 = c;
            char c3 = c2;
            if ('0' <= c3 && '9' >= c3) {
                n = c - 48;
            } else {
                c3 = c2;
                if ('a' <= c3 && 'f' >= c3) {
                    n = c - 97 + 10;
                } else {
                    c3 = c2;
                    if ('A' <= c3 && 'F' >= c3) {
                        n = c - 65 + 10;
                    } else {
                        throw (Throwable)new ParseException("None-hex character in unicode escape sequence: " + c);
                    }
                }
            }
            return n;
        }

        @NotNull
        public final String discardEscapeChar(@NotNull String input) throws ParseException {
            int n;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            char[] output = new char[input.length()];
            int length = 0;
            boolean lastCharWasEscapeChar = false;
            int codePointMultiplier = 0;
            int codePoint = 0;
            String string = input;
            int n2 = string.length();
            for (n = 0; n < n2; ++n) {
                char element = string.charAt(n);
                if (codePointMultiplier > 0) {
                    codePoint += this.hexToInt(element) * codePointMultiplier;
                    if ((codePointMultiplier >>>= 4) != 0) continue;
                    output[length++] = (char)codePoint;
                    codePoint = 0;
                    continue;
                }
                if (lastCharWasEscapeChar) {
                    if (element == 'u') {
                        codePointMultiplier = 4096;
                    } else {
                        output[length] = element;
                        ++length;
                    }
                    lastCharWasEscapeChar = false;
                    continue;
                }
                if (element == '\\') {
                    lastCharWasEscapeChar = true;
                    continue;
                }
                output[length] = element;
                ++length;
            }
            if (codePointMultiplier > 0) {
                throw (Throwable)new ParseException("Truncated unicode escape sequence.");
            }
            if (lastCharWasEscapeChar) {
                throw (Throwable)new ParseException("Term can not end with escape character.");
            }
            int n3 = 0;
            n = 0;
            return new String(output, n3, length);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

