/*
 * Decompiled with CFR 0.152.
 */
package ma.ju.fieldmask.spring;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ma.ju.fieldmask.core.ParseException;
import ma.ju.fieldmask.core.UnknownFieldMaskException;
import ma.ju.fieldmask.spring.DefaultFieldMaskContextBuilder;
import ma.ju.fieldmask.spring.FieldMaskContextBuilder;
import ma.ju.fieldmask.spring.FieldMaskParameterResolver;
import ma.ju.fieldmask.spring.FieldMaskProperties;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@EnableConfigurationProperties(value={FieldMaskProperties.class})
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0017J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lma/ju/fieldmask/spring/FieldMaskAutoConfiguration;", "Lorg/springframework/web/servlet/config/annotation/WebMvcConfigurer;", "()V", "fieldMaskProperties", "Lma/ju/fieldmask/spring/FieldMaskProperties;", "addArgumentResolvers", "", "resolvers", "", "Lorg/springframework/web/method/support/HandlerMethodArgumentResolver;", "fieldMaskContextBuilder", "Lma/ju/fieldmask/spring/DefaultFieldMaskContextBuilder;", "handleInvalidMask", "ex", "Lma/ju/fieldmask/core/UnknownFieldMaskException;", "res", "Ljavax/servlet/http/HttpServletResponse;", "fieldmask-spring"})
public class FieldMaskAutoConfiguration
implements WebMvcConfigurer {
    @Autowired
    private FieldMaskProperties fieldMaskProperties;

    @Bean
    @ConditionalOnMissingBean(type={"FieldMaskContextBuilder"})
    @NotNull
    public DefaultFieldMaskContextBuilder fieldMaskContextBuilder() {
        FieldMaskProperties fieldMaskProperties = this.fieldMaskProperties;
        if (fieldMaskProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldMaskProperties");
        }
        return new DefaultFieldMaskContextBuilder(fieldMaskProperties);
    }

    public void addArgumentResolvers(@NotNull List<HandlerMethodArgumentResolver> resolvers) {
        Intrinsics.checkNotNullParameter(resolvers, (String)"resolvers");
        FieldMaskContextBuilder fieldMaskContextBuilder = this.fieldMaskContextBuilder();
        FieldMaskProperties fieldMaskProperties = this.fieldMaskProperties;
        if (fieldMaskProperties == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"fieldMaskProperties");
        }
        resolvers.add(new FieldMaskParameterResolver(fieldMaskContextBuilder, fieldMaskProperties));
    }

    @ExceptionHandler(value={UnknownFieldMaskException.class, ParseException.class})
    public final void handleInvalidMask(@NotNull UnknownFieldMaskException ex, @NotNull HttpServletResponse res) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        res.sendError(HttpStatus.BAD_REQUEST.value(), ex.getMessage());
    }
}

