/*
 * Decompiled with CFR 0.152.
 */
package ma.ju.fieldmask.spring;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import ma.ju.fieldmask.core.ParseException;
import ma.ju.fieldmask.core.UnknownFieldMaskException;
import ma.ju.fieldmask.spring.FieldMaskException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
@ResponseBody
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\fH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lma/ju/fieldmask/spring/FieldMaskExceptionHandler;", "Lorg/springframework/web/servlet/mvc/method/annotation/ResponseEntityExceptionHandler;", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "parseException", "Lorg/springframework/http/ResponseEntity;", "Lma/ju/fieldmask/spring/FieldMaskException;", "ex", "Lma/ju/fieldmask/core/ParseException;", "unknownFieldException", "Lma/ju/fieldmask/core/UnknownFieldMaskException;", "fieldmask-spring"})
public final class FieldMaskExceptionHandler
extends ResponseEntityExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(FieldMaskExceptionHandler.class);

    @ExceptionHandler(value={UnknownFieldMaskException.class})
    @NotNull
    public final ResponseEntity<FieldMaskException> unknownFieldException(@NotNull UnknownFieldMaskException ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.logger.error((Object)"unknown FieldMask provided", (Throwable)ex);
        String string = ex.getMessage();
        if (string == null) {
            string = "";
        }
        FieldMaskException error = new FieldMaskException(string, HttpStatus.BAD_REQUEST.value(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"fields", (Object)ex.getFields())), (Exception)ex, null, 16, null);
        return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
    }

    @ExceptionHandler(value={ParseException.class})
    @NotNull
    public final ResponseEntity<FieldMaskException> parseException(@NotNull ParseException ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        this.logger.error((Object)"invalid FieldMask provided", (Throwable)ex);
        String string = ex.getMessage();
        if (string == null) {
            string = "";
        }
        FieldMaskException error = new FieldMaskException(string, HttpStatus.BAD_REQUEST.value(), null, null, null, 28, null);
        return new ResponseEntity((Object)error, HttpStatus.BAD_REQUEST);
    }
}

