package me.xx2bab.polyfill.manifest.source

import com.android.build.api.extension.AndroidComponentsExtension
import com.android.build.api.variant.Variant
import com.android.build.gradle.tasks.ProcessApplicationManifest
import me.xx2bab.polyfill.matrix.base.ApplicationSelfManageableProvider
import org.gradle.api.Project
import org.gradle.api.file.FileCollection
import org.gradle.api.file.FileSystemLocation

class ManifestMergeInputProvider : ApplicationSelfManageableProvider<Set<FileSystemLocation>> {

    private lateinit var manifests: FileCollection

    override fun initialize(
        project: Project,
        androidExtension: AndroidComponentsExtension<*, *>,
        variant: Variant
    ) {
        val t = project.tasks.withType(ProcessApplicationManifest::class.java)
        manifests = t.filter {
            it.name.contains(variant.name, true)
        }.first().getManifests()
    }

    override fun get(defaultValue: Set<FileSystemLocation>?): Set<FileSystemLocation>? {
        return manifests.elements.get()
    }

    override fun isPresent() = ::manifests.isInitialized && manifests.elements.isPresent

}