/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.manifest.bytes.parser;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.xx2bab.polyfill.arsc.base.CommonConstantsKt;
import me.xx2bab.polyfill.arsc.base.IParsable;
import me.xx2bab.polyfill.arsc.io.ByteBufferExtensionKt;
import me.xx2bab.polyfill.arsc.io.LittleEndianInputStream;
import me.xx2bab.polyfill.manifest.bytes.parser.Header;
import me.xx2bab.polyfill.manifest.bytes.parser.ResourceIdBlock;
import me.xx2bab.polyfill.manifest.bytes.parser.StringPoolBlock;
import me.xx2bab.polyfill.manifest.bytes.parser.body.EndNamespaceXmlBody;
import me.xx2bab.polyfill.manifest.bytes.parser.body.EndTagXmlBody;
import me.xx2bab.polyfill.manifest.bytes.parser.body.StartNamespaceXmlBody;
import me.xx2bab.polyfill.manifest.bytes.parser.body.StartTagXmlBody;
import me.xx2bab.polyfill.manifest.bytes.parser.body.TextXmlBody;
import me.xx2bab.polyfill.manifest.bytes.parser.body.XMLBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c\u00a8\u0006%"}, d2={"Lme/xx2bab/polyfill/manifest/bytes/parser/ManifestBlock;", "Lme/xx2bab/polyfill/arsc/base/IParsable;", "()V", "bodyList", "", "Lme/xx2bab/polyfill/manifest/bytes/parser/body/XMLBody;", "getBodyList", "()Ljava/util/List;", "fileSize", "", "getFileSize", "()I", "setFileSize", "(I)V", "magicNumber", "getMagicNumber", "setMagicNumber", "resourceIdBlock", "Lme/xx2bab/polyfill/manifest/bytes/parser/ResourceIdBlock;", "getResourceIdBlock", "()Lme/xx2bab/polyfill/manifest/bytes/parser/ResourceIdBlock;", "setResourceIdBlock", "(Lme/xx2bab/polyfill/manifest/bytes/parser/ResourceIdBlock;)V", "stringBlock", "Lme/xx2bab/polyfill/manifest/bytes/parser/StringPoolBlock;", "getStringBlock", "()Lme/xx2bab/polyfill/manifest/bytes/parser/StringPoolBlock;", "setStringBlock", "(Lme/xx2bab/polyfill/manifest/bytes/parser/StringPoolBlock;)V", "parse", "", "input", "Lme/xx2bab/polyfill/arsc/io/LittleEndianInputStream;", "start", "", "toByteArray", "", "polyfill-manifest"})
public final class ManifestBlock
implements IParsable {
    private int magicNumber = -2147483647;
    private int fileSize = -2147483647;
    public StringPoolBlock stringBlock;
    public ResourceIdBlock resourceIdBlock;
    @NotNull
    private final List<XMLBody> bodyList;

    public ManifestBlock() {
        boolean bl = false;
        this.bodyList = new ArrayList();
    }

    public final int getMagicNumber() {
        return this.magicNumber;
    }

    public final void setMagicNumber(int n) {
        this.magicNumber = n;
    }

    public final int getFileSize() {
        return this.fileSize;
    }

    public final void setFileSize(int n) {
        this.fileSize = n;
    }

    @NotNull
    public final StringPoolBlock getStringBlock() {
        StringPoolBlock stringPoolBlock = this.stringBlock;
        if (stringPoolBlock != null) {
            return stringPoolBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stringBlock");
        return null;
    }

    public final void setStringBlock(@NotNull StringPoolBlock stringPoolBlock) {
        Intrinsics.checkNotNullParameter((Object)stringPoolBlock, (String)"<set-?>");
        this.stringBlock = stringPoolBlock;
    }

    @NotNull
    public final ResourceIdBlock getResourceIdBlock() {
        ResourceIdBlock resourceIdBlock = this.resourceIdBlock;
        if (resourceIdBlock != null) {
            return resourceIdBlock;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"resourceIdBlock");
        return null;
    }

    public final void setResourceIdBlock(@NotNull ResourceIdBlock resourceIdBlock) {
        Intrinsics.checkNotNullParameter((Object)resourceIdBlock, (String)"<set-?>");
        this.resourceIdBlock = resourceIdBlock;
    }

    @NotNull
    public final List<XMLBody> getBodyList() {
        return this.bodyList;
    }

    public void parse(@NotNull LittleEndianInputStream input, long start) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.magicNumber = input.readInt();
        this.fileSize = input.readInt();
        this.setStringBlock(new StringPoolBlock());
        this.getStringBlock().parse(input, input.getFilePointer());
        this.setResourceIdBlock(new ResourceIdBlock());
        this.getResourceIdBlock().parse(input, input.getFilePointer());
        while (input.getFilePointer() < (long)this.fileSize) {
            XMLBody xMLBody;
            Header bodyHeader = new Header();
            bodyHeader.parse(input, input.getFilePointer());
            int n = bodyHeader.getChunkType();
            switch (n) {
                case 0x100100: {
                    xMLBody = new StartNamespaceXmlBody();
                    break;
                }
                case 0x100101: {
                    xMLBody = new EndNamespaceXmlBody();
                    break;
                }
                case 0x100102: {
                    xMLBody = new StartTagXmlBody();
                    break;
                }
                case 0x100103: {
                    xMLBody = new EndTagXmlBody();
                    break;
                }
                case 0x100104: {
                    xMLBody = new TextXmlBody();
                    break;
                }
                default: {
                    throw new Exception(Intrinsics.stringPlus((String)"Unsupported XMLBodyType: ", (Object)bodyHeader.getChunkType()));
                }
            }
            XMLBody xmlBody = xMLBody;
            xmlBody.setHeader(bodyHeader);
            xmlBody.parse(input, input.getFilePointer());
            this.bodyList.add(xmlBody);
            input.seek(bodyHeader.getStart());
            input.skip((long)bodyHeader.getChunkSize());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public byte[] toByteArray() {
        void $this$mapTo$iv$iv;
        byte[] stringBlockByteArray = this.getStringBlock().toByteArray();
        byte[] resourceIdBlockByteArray = this.getResourceIdBlock().toByteArray();
        Iterable $this$map$iv = this.bodyList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            XMLBody xMLBody = (XMLBody)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            byte[] byArray = it.toByteArray();
            collection.add(byArray);
        }
        List bodyListByteArrayList = (List)destination$iv$iv;
        Iterable $this$sumBy$iv = bodyListByteArrayList;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            void it;
            Object item$iv$iv;
            item$iv$iv = (byte[])element$iv;
            int n = sum$iv;
            boolean bl = false;
            int n2 = ((void)it).length;
            sum$iv = n + n2;
        }
        int bodyListByteArrayListSize = sum$iv;
        int newChunkSize = CommonConstantsKt.sizeOf((Object)this.magicNumber) + CommonConstantsKt.sizeOf((Object)this.fileSize) + stringBlockByteArray.length + resourceIdBlockByteArray.length + bodyListByteArrayListSize;
        ByteBuffer bf = ByteBuffer.allocate(newChunkSize);
        Intrinsics.checkNotNullExpressionValue((Object)bf, (String)"bf");
        ByteBufferExtensionKt.takeLittleEndianOrder((ByteBuffer)bf);
        bf.putInt(this.magicNumber);
        bf.putInt(newChunkSize);
        bf.put(stringBlockByteArray);
        bf.put(resourceIdBlockByteArray);
        Iterable $this$forEach$iv = bodyListByteArrayList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            byte[] it = (byte[])element$iv;
            boolean bl = false;
            bf.put(it);
        }
        return ByteBufferExtensionKt.flipToArray((ByteBuffer)bf);
    }
}

