/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.manifest.bytes.parser;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.xx2bab.polyfill.arsc.io.LittleEndianInputStream;
import me.xx2bab.polyfill.arsc.io.LittleEndianOutputStream;
import me.xx2bab.polyfill.manifest.bytes.parser.IManifestBytesTweaker;
import me.xx2bab.polyfill.manifest.bytes.parser.ManifestBlock;
import me.xx2bab.polyfill.manifest.bytes.parser.body.Attribute;
import me.xx2bab.polyfill.manifest.bytes.parser.body.StartTagXmlBody;
import me.xx2bab.polyfill.manifest.bytes.parser.body.XMLBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\nJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lme/xx2bab/polyfill/manifest/bytes/parser/ManifestBytesTweaker;", "Lme/xx2bab/polyfill/manifest/bytes/parser/IManifestBytesTweaker;", "()V", "manifestBlock", "Lme/xx2bab/polyfill/manifest/bytes/parser/ManifestBlock;", "getAttrFromTagAttrs", "Lme/xx2bab/polyfill/manifest/bytes/parser/body/Attribute;", "tag", "Lme/xx2bab/polyfill/manifest/bytes/parser/body/StartTagXmlBody;", "attrName", "", "getManifestBlock", "getSpecifyStartTagBodyByName", "tagName", "read", "", "source", "Ljava/io/File;", "updatePackageName", "newPackageName", "write", "dest", "manifest", "polyfill-manifest"})
public final class ManifestBytesTweaker
implements IManifestBytesTweaker {
    @NotNull
    private final ManifestBlock manifestBlock = new ManifestBlock();

    @Override
    public void read(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source.exists() && source.isFile()) {
            LittleEndianInputStream inputStream = new LittleEndianInputStream(source);
            this.manifestBlock.parse(inputStream, 0L);
            return;
        }
        throw new IllegalArgumentException("The input file is illegal.");
    }

    @Override
    public void write(@NotNull File dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        this.write(dest, this.manifestBlock);
    }

    @Override
    public void write(@NotNull File dest, @NotNull ManifestBlock manifest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)manifest, (String)"manifest");
        if (dest.exists()) {
            dest.delete();
        }
        dest.getParentFile().mkdirs();
        dest.createNewFile();
        LittleEndianOutputStream outputStream = new LittleEndianOutputStream(dest);
        outputStream.writeByte(manifest.toByteArray());
        outputStream.close();
    }

    @VisibleForTesting
    @NotNull
    public final ManifestBlock getManifestBlock() {
        return this.manifestBlock;
    }

    @Override
    public void updatePackageName(@NotNull String newPackageName) {
        Intrinsics.checkNotNullParameter((Object)newPackageName, (String)"newPackageName");
        StartTagXmlBody startTagXmlBody = this.getSpecifyStartTagBodyByName("manifest");
        if (startTagXmlBody == null) {
            throw new IllegalStateException("Could not found <manifest> tag");
        }
        StartTagXmlBody applicationTag = startTagXmlBody;
        Attribute attribute = this.getAttrFromTagAttrs(applicationTag, "package");
        if (attribute == null) {
            throw new IllegalStateException("Could not found package");
        }
        Attribute ackageName = attribute;
        this.manifestBlock.getStringBlock().getStrings()[ackageName.getValueIndex()] = newPackageName;
    }

    @Nullable
    public final StartTagXmlBody getSpecifyStartTagBodyByName(@NotNull String tagName) {
        XMLBody it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Iterable $this$filter$iv = this.manifestBlock.getBodyList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XMLBody)element$iv$iv;
            boolean bl = false;
            if (!(it.getHeader().getChunkType() == 0x100102)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XMLBody)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.manifestBlock.getStringBlock().getStrings()[((StartTagXmlBody)it).getName()], (Object)tagName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Collection collection = list;
        boolean bl = false;
        boolean bl2 = false;
        return collection.isEmpty() ? (StartTagXmlBody)null : (StartTagXmlBody)list.get(0);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Attribute getAttrFromTagAttrs(@NotNull StartTagXmlBody tag, @NotNull String attrName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)attrName, (String)"attrName");
        Iterable $this$filter$iv = tag.getAttrs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Attribute it = (Attribute)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)this.manifestBlock.getStringBlock().getStrings()[it.getNameIndex()], (Object)attrName)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List res = (List)destination$iv$iv;
        Collection collection = res;
        boolean bl = false;
        boolean bl2 = false;
        return collection.isEmpty() ? null : (Attribute)res.get(0);
    }
}

