/*
 * Decompiled with CFR 0.152.
 */
package me.xx2bab.polyfill.manifest.bytes.parser;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.xx2bab.polyfill.arsc.base.IParsable;
import me.xx2bab.polyfill.arsc.io.ByteBufferExtensionKt;
import me.xx2bab.polyfill.arsc.io.LittleEndianInputStream;
import me.xx2bab.polyfill.manifest.bytes.parser.Header;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lme/xx2bab/polyfill/manifest/bytes/parser/ResourceIdBlock;", "Lme/xx2bab/polyfill/arsc/base/IParsable;", "()V", "header", "Lme/xx2bab/polyfill/manifest/bytes/parser/Header;", "getHeader", "()Lme/xx2bab/polyfill/manifest/bytes/parser/Header;", "setHeader", "(Lme/xx2bab/polyfill/manifest/bytes/parser/Header;)V", "idArray", "", "getIdArray", "()[I", "setIdArray", "([I)V", "parse", "", "input", "Lme/xx2bab/polyfill/arsc/io/LittleEndianInputStream;", "start", "", "toByteArray", "", "polyfill-manifest"})
public final class ResourceIdBlock
implements IParsable {
    public Header header;
    public int[] idArray;

    @NotNull
    public final Header getHeader() {
        Header header = this.header;
        if (header != null) {
            return header;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"header");
        return null;
    }

    public final void setHeader(@NotNull Header header) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"<set-?>");
        this.header = header;
    }

    @NotNull
    public final int[] getIdArray() {
        int[] nArray = this.idArray;
        if (nArray != null) {
            return nArray;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"idArray");
        return null;
    }

    public final void setIdArray(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.idArray = nArray;
    }

    public void parse(@NotNull LittleEndianInputStream input, long start) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        input.seek(start);
        this.setHeader(new Header());
        this.getHeader().parse(input, start);
        int resourceIdChunkCount = (this.getHeader().getChunkSize() - this.getHeader().size()) / 4;
        this.setIdArray(new int[resourceIdChunkCount]);
        int n = 0;
        if (n < resourceIdChunkCount) {
            do {
                int i = n++;
                this.getIdArray()[i] = input.readInt();
            } while (n < resourceIdChunkCount);
        }
    }

    @NotNull
    public byte[] toByteArray() {
        int newChunkSize = this.getHeader().size() + this.getIdArray().length * 4;
        ByteBuffer bf = ByteBuffer.allocate(newChunkSize);
        Intrinsics.checkNotNullExpressionValue((Object)bf, (String)"bf");
        ByteBufferExtensionKt.takeLittleEndianOrder((ByteBuffer)bf);
        bf.putInt(this.getHeader().getChunkType());
        bf.putInt(newChunkSize);
        int[] $this$forEach$iv = this.getIdArray();
        boolean $i$f$forEach = false;
        int[] nArray = $this$forEach$iv;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = nArray[i];
            boolean bl = false;
            bf.putInt(it);
        }
        return ByteBufferExtensionKt.flipToArray((ByteBuffer)bf);
    }
}

