package me.adkhambek.gsa

import com.google.auto.service.AutoService
import com.google.devtools.ksp.processing.Resolver
import com.google.devtools.ksp.processing.SymbolProcessor
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment
import com.google.devtools.ksp.processing.SymbolProcessorProvider
import com.google.devtools.ksp.symbol.KSAnnotated
import com.google.devtools.ksp.symbol.KSClassDeclaration
import com.google.devtools.ksp.validate
import me.adkhambek.gsa.compiler.parser.ArgumentParser
import me.adkhambek.gsa.compiler.parser.ParserVisitor
import me.adkhambek.gsa.compiler.parser.ScreenParser
import me.adkhambek.gsa.compiler.utils.SCREEN_TYPE_QUALIFIED_NAME
import me.adkhambek.gsa.compiler.validator.SymbolValidator
import me.adkhambek.gsa.compiler.writer.Writer

internal class CiceroneKspProcessor(
    private val processingEnv: SymbolProcessorEnvironment,
) : SymbolProcessor {

    private val validator: SymbolValidator = SymbolValidator()

    override fun process(resolver: Resolver): List<KSAnnotated> {
        val writer = Writer(generator = processingEnv.codeGenerator)

        val visitor = ParserVisitor(
            resolver = resolver,
            argumentVisitor = ScreenParser(
                argumentParser = ArgumentParser(resolver)
            )
        )

        val resolved = resolver
            .getSymbolsWithAnnotation(SCREEN_TYPE_QUALIFIED_NAME)
            .toList()

        val validatedSymbols: List<KSClassDeclaration> = resolved
            .filterIsInstance<KSClassDeclaration>()
            .filter(KSAnnotated::validate)
            .toList()

        validatedSymbols
            .filter(validator::isValid)
            .map { it.accept(visitor, Unit) }
            .let(writer::write)

        return resolved - validatedSymbols.toSet()
    }

    @AutoService(SymbolProcessorProvider::class)
    class Provider : SymbolProcessorProvider {
        override fun create(environment: SymbolProcessorEnvironment): SymbolProcessor {
            return CiceroneKspProcessor(environment)
        }
    }
}