package me.adkhambek.gsa.compiler.parser

import com.google.devtools.ksp.processing.Resolver
import com.google.devtools.ksp.symbol.KSAnnotation
import com.google.devtools.ksp.symbol.KSType
import com.squareup.kotlinpoet.ksp.toClassName
import me.adkhambek.gsa.compiler.model.ArgumentInfo
import me.adkhambek.gsa.compiler.utils.ARG_KEY
import me.adkhambek.gsa.compiler.utils.ARG_NAME
import me.adkhambek.gsa.compiler.utils.ARG_NULLABLE
import me.adkhambek.gsa.compiler.utils.ARG_TYPE
import me.adkhambek.gsa.compiler.utils.isValidParcelableData
import me.adkhambek.gsa.compiler.utils.requiredArgument

class ArgumentParser(
    private val resolver: Resolver,
) {

    fun visitValueArgument(annotation: KSAnnotation): ArgumentInfo {

        val key: Boolean = annotation.requiredArgument(ARG_KEY)
        val type: KSType = annotation.requiredArgument(ARG_TYPE)
        val name: String = annotation.requiredArgument(ARG_NAME)
        val isNullable: Boolean = annotation.requiredArgument(ARG_NULLABLE)

        check(type.isValidParcelableData(resolver)) {
            "Type must be Parcelable/Serializable/Primitive"
        }

        return ArgumentInfo(
            key = key,
            name = name,
            isNullable = isNullable,
            type = type.toClassName(),
        )
    }
}