package me.adkhambek.gsa.compiler.parser

import com.google.devtools.ksp.processing.Resolver
import com.google.devtools.ksp.symbol.KSClassDeclaration
import com.google.devtools.ksp.symbol.KSNode
import com.google.devtools.ksp.visitor.KSEmptyVisitor
import com.squareup.kotlinpoet.ksp.toClassName
import me.adkhambek.gsa.annotation.Screen
import me.adkhambek.gsa.compiler.model.ScreenInfo
import me.adkhambek.gsa.compiler.utils.findAnnotations

class ParserVisitor(
    private val resolver: Resolver,
    private val argumentVisitor: ScreenParser,
) : KSEmptyVisitor<Unit, ScreenInfo>() {

    override fun visitClassDeclaration(classDeclaration: KSClassDeclaration, data: Unit): ScreenInfo {
        val listOfScreenInfo = classDeclaration
            .findAnnotations<Screen>(resolver = resolver)
            .map { annotation ->
                val fr = classDeclaration.asType(emptyList()).toClassName()
                argumentVisitor.visitAnnotation(annotation, fr)
            }

        return listOfScreenInfo.first()
    }

    override fun defaultHandler(node: KSNode, data: Unit): ScreenInfo {
        TODO("Not support")
    }
}

