package me.adkhambek.gsa.compiler.parser

import com.google.devtools.ksp.symbol.KSAnnotation
import com.google.devtools.ksp.symbol.KSType
import com.squareup.kotlinpoet.ClassName
import com.squareup.kotlinpoet.ksp.toClassName
import me.adkhambek.gsa.compiler.model.ArgumentInfo
import me.adkhambek.gsa.compiler.model.ScreenInfo
import me.adkhambek.gsa.compiler.utils.ARG_ARGS
import me.adkhambek.gsa.compiler.utils.ARG_CLEAR_CONTAINER
import me.adkhambek.gsa.compiler.utils.INSTALL_IN
import me.adkhambek.gsa.compiler.utils.requiredArgument

class ScreenParser(
    private val argumentParser: ArgumentParser,
) {
    fun visitAnnotation(annotation: KSAnnotation, fr: ClassName): ScreenInfo {

        val installIn: KSType = annotation.requiredArgument(INSTALL_IN)
        val args: List<KSAnnotation> = annotation.requiredArgument(ARG_ARGS)
        val clearContainer: Boolean = annotation.requiredArgument(ARG_CLEAR_CONTAINER)

        val arguments: List<ArgumentInfo> = args
            .map(argumentParser::visitValueArgument)

        return ScreenInfo(
            fragment = fr,
            arguments = arguments,
            clearContainer = clearContainer,
            installIn = installIn.toClassName(),
        )
    }
}

