package me.adkhambek.gsa.compiler.utils

import com.squareup.kotlinpoet.ClassName
import me.adkhambek.gsa.annotation.Arg
import me.adkhambek.gsa.annotation.Screen


internal val SCREEN_TYPE_SIMPLE_NAME: String = Screen::class.simpleName!!
internal val SCREEN_TYPE_QUALIFIED_NAME: String = Screen::class.qualifiedName!!

internal val ARG_TYPE_SIMPLE_NAME: String = Arg::class.simpleName!!
internal val ARG_TYPE_QUALIFIED_NAME: String = Arg::class.qualifiedName!!

internal const val INSTALL_IN = "installIn"

internal const val ARG_KEY = "key"
internal const val ARG_ARGS = "args"
internal const val ARG_TYPE = "type"
internal const val ARG_NAME = "name"
internal const val ARG_NULLABLE = "isNullable"
internal const val ARG_CLEAR_CONTAINER = "clearContainer"


internal val STRING_BUILDER_CLASSNAME = ClassName("java.lang", "StringBuilder")

internal val SCREEN_FRAGMENT_CLASSNAME = ClassName("com.github.terrakok.cicerone.androidx", "FragmentScreen")
internal val SCREEN_ACTIVITY_CLASSNAME = ClassName("com.github.terrakok.cicerone.androidx", "ActivityScreen")

internal val PARCELABLE_CLASSNAME = ClassName("android.os", "Parcelable")
internal val SERIALIZABLE_CLASSNAME = ClassName("java.io", "Serializable")

internal const val ARG_BUNDLE: String = "bundle"
internal val BUNDLE_CLASSNAME: ClassName = ClassName("android.os", "Bundle")
