package me.adkhambek.gsa.compiler.utils


import com.google.devtools.ksp.getClassDeclarationByName
import com.google.devtools.ksp.processing.Resolver
import com.google.devtools.ksp.symbol.KSAnnotated
import com.google.devtools.ksp.symbol.KSAnnotation
import com.google.devtools.ksp.symbol.KSType
import com.squareup.kotlinpoet.BOOLEAN
import com.squareup.kotlinpoet.BYTE
import com.squareup.kotlinpoet.CHAR
import com.squareup.kotlinpoet.DOUBLE
import com.squareup.kotlinpoet.FLOAT
import com.squareup.kotlinpoet.INT
import com.squareup.kotlinpoet.LONG
import com.squareup.kotlinpoet.SHORT
import com.squareup.kotlinpoet.STRING
import com.squareup.kotlinpoet.ksp.toClassName

private val SUPPORT_TYPES = setOf(
    BOOLEAN,
    BYTE,
    SHORT,
    INT,
    LONG,
    CHAR,
    FLOAT,
    DOUBLE,
    STRING,
)


@Throws(IllegalStateException::class)
internal inline fun <reified R> KSAnnotation.requiredArgument(name: String): R {
    return arguments
        .firstOrNull { it.name?.asString() == name }
        ?.value as? R? ?: error("Argument \"$name\" type not found")
}

internal fun KSType.isValidParcelableData(resolver: Resolver): Boolean {
    if (SUPPORT_TYPES.contains(this.toClassName())) return true

    val parcelable = resolver.getClassDeclarationByName("android.os.Parcelable")
    val serializable = resolver.getClassDeclarationByName("java.io.Serializable")

    return (parcelable != null && parcelable.asType(emptyList()).isAssignableFrom(this)) ||
            (serializable != null && serializable.asType(emptyList()).isAssignableFrom(this))
}

/**
 *  @returns [List<KSAnnotation>]
 */
inline fun <reified T> KSAnnotated.findAnnotations(resolver: Resolver): Sequence<KSAnnotation> {
    val annotationKsName = resolver.getKSNameFromString(T::class.simpleName!!)
    return annotations.filter { it.shortName.asString() == annotationKsName.asString() }
}
