package me.adkhambek.gsa.compiler.validator

import com.google.devtools.ksp.symbol.KSAnnotated
import com.google.devtools.ksp.symbol.KSClassDeclaration
import com.google.devtools.ksp.validate

internal class SymbolValidator {

    fun isValid(symbol: KSAnnotated): Boolean {
        return symbol is KSClassDeclaration
                && symbol.validate()
                && symbol.isFragment()
//                && symbol.isValidParcelableData()
    }


    private fun KSClassDeclaration.isSubclassOf(
        superClassName: String,
    ): Boolean {
        val superClasses = superTypes.toMutableList()
        while (superClasses.isNotEmpty()) {
            val current = superClasses.first()
            val declaration = current.resolve().declaration
            when {
                declaration is KSClassDeclaration && declaration.qualifiedName?.asString() == superClassName -> {
                    return true
                }
                declaration is KSClassDeclaration -> {
                    superClasses.removeAt(0)
                    superClasses.addAll(0, declaration.superTypes.toList())
                }
                else -> {
                    superClasses.removeAt(0)
                }
            }
        }
        return false
    }

    private fun KSClassDeclaration.isFragment(): Boolean {
        val androidFragment = "androidx.fragment.app.Fragment"
        return isSubclassOf(androidFragment)
    }
}
