package me.adkhambek.gsa.compiler.writer

import com.squareup.kotlinpoet.BOOLEAN
import com.squareup.kotlinpoet.BYTE
import com.squareup.kotlinpoet.CHAR
import com.squareup.kotlinpoet.ClassName
import com.squareup.kotlinpoet.DOUBLE
import com.squareup.kotlinpoet.FLOAT
import com.squareup.kotlinpoet.FunSpec
import com.squareup.kotlinpoet.INT
import com.squareup.kotlinpoet.LONG
import com.squareup.kotlinpoet.SHORT
import com.squareup.kotlinpoet.STRING
import me.adkhambek.gsa.compiler.model.ArgumentInfo

internal fun ClassName.addBundlePutStatement(
    builder: FunSpec.Builder,
    arg: ArgumentInfo,
    bundle: String,
    argValue: String,
): FunSpec.Builder {

    builder.addStatement(
        format = "%L.%L(%S, %L)",
        bundle,
        bundlePutMethod(),
        arg.name,
        argValue
    )

    return builder
}

internal fun ClassName.bundlePutMethod(): String = when (this) {
    BOOLEAN -> "putBoolean"
    BYTE -> "putByte"
    SHORT -> "putShort"
    INT -> "putInt"
    LONG -> "putLong"
    CHAR -> "putChar"
    FLOAT -> "putFloat"
    DOUBLE -> "putDouble"
    STRING -> "putString"
    else -> "putParcelable"
}

////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////

const val NULLABLE_VAR: String = "val %L: %T? = %L.%L(%S) //  { %S }"
const val NON_NULLABLE_VAR: String = "val %L: %T = requireNotNull(%L.%L(%S)) { %S }"

internal fun ClassName.addBundleGetStatement(
    builder: FunSpec.Builder,
    arg: ArgumentInfo,
    bundle: String,
    argValue: String,
): FunSpec.Builder {

    builder.addStatement(
        format = if (arg.isNullable) NULLABLE_VAR else NON_NULLABLE_VAR,
        argValue,
        this,
        bundle,
        bundleGetMethod(arg),
        arg.name,
        "Argument ${arg.name} not found"
    )

    return builder
}

internal fun ClassName.bundleGetMethod(arg: ArgumentInfo): String = when (this) {
    BOOLEAN -> "getBoolean"
    BYTE -> "getByte"
    SHORT -> "getShort"
    INT -> "getInt"
    LONG -> "getLong"
    CHAR -> "getChar"
    FLOAT -> "getFloat"
    DOUBLE -> "getDouble"
    STRING -> "getString"
    else -> "getParcelable<${arg.type.simpleName}>"
}