package me.adkhambek.gsa.compiler.writer

import com.google.devtools.ksp.processing.CodeGenerator
import com.squareup.kotlinpoet.ksp.writeTo
import me.adkhambek.gsa.compiler.generator.ArgumentHolderGenerator
import me.adkhambek.gsa.compiler.generator.ScreenGenerator
import me.adkhambek.gsa.compiler.model.ScreenInfo

class Writer(
    private val generator: CodeGenerator,
) {

    fun write(info: List<ScreenInfo>) {
        val arguments = ArgumentHolderGenerator().gen(info)
        val screens = ScreenGenerator().gen(info)

        arguments.forEach { spec ->
            spec.writeTo(generator, aggregating = true)
        }
        screens.forEach { spec ->
            spec.writeTo(generator, aggregating = true)
        }
    }
}