package me.adkhambek.gsa.compiler.writer

import com.google.devtools.ksp.processing.CodeGenerator
import com.google.devtools.ksp.processing.Dependencies
import com.squareup.kotlinpoet.ksp.writeTo
import me.adkhambek.gsa.compiler.generator.ArgumentHolderGenerator
import me.adkhambek.gsa.compiler.generator.ScreenGenerator
import me.adkhambek.gsa.model.ScreenInfo

internal class Writer(
    private val generator: CodeGenerator,
    private val screenGenerator: ScreenGenerator,
    private val argumentHolderGenerator: ArgumentHolderGenerator,
) {

    fun write(info: List<ScreenInfo>) {
        val arguments = argumentHolderGenerator.gen(info)
        val screens = screenGenerator.gen(info)


        arguments.forEach { spec ->
            spec.writeTo(generator, dependencies = Dependencies.ALL_FILES)
        }
        screens.forEach { spec ->
            spec.writeTo(generator, dependencies = Dependencies.ALL_FILES)
        }
    }
}