package me.adkhambek.gsa.utils

import com.squareup.kotlinpoet.ClassName
import com.squareup.kotlinpoet.FunSpec
import com.squareup.kotlinpoet.ksp.toClassName
import me.adkhambek.gsa.model.ArgumentInfo

internal fun FunSpec.Builder.addArguments(
    arguments: List<ArgumentInfo>,
): FunSpec.Builder {

    arguments.forEach { arg ->
        val argClassName = arg.type.toClassName()
        addParameter(arg.name.toCamelCaseAsVar(), argClassName.copy(nullable = arg.isNullable))
    }

    return this
}

internal fun FunSpec.Builder.addCreateArgs(
    variable: String,
    argumentClassName: ClassName,
    arguments: List<ArgumentInfo>,
): FunSpec.Builder {

    addStatement("val %L = %T(", variable, argumentClassName)

    arguments.forEach { arg ->
        addStatement("\t%L = %L,", arg.name.toCamelCaseAsVar(), arg.name.toCamelCaseAsVar())
    }

    addStatement(")")
    return this
}
