package me.adkhambek.gsa.utils

import com.squareup.kotlinpoet.ClassName

internal object NameUtil {

    @JvmStatic
    fun argumentClass(className: ClassName): String {
        val simpleName = screenClass(className)
        return simpleName + "Args"
    }

    @JvmStatic
    fun screenClass(className: ClassName): String {
        val simpleName = className.simpleName

        return if (simpleName.endsWith("Fragment")) {
            simpleName.replace("Fragment", "Screen")
        } else simpleName.plus("Screen")
    }

    @JvmStatic
    fun screensClass(className: ClassName): String {
        val simpleName = className.simpleName
        return simpleName.plus("Screens")
    }
}