/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.io.IOException;
import java.util.Objects;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.SnowflakeFriendlyIdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.jackson.AsString;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;

public class AsStringSerializer
extends JsonSerializer<Long>
implements ContextualSerializer {
    private static final AsStringSerializer TO_STRING = new AsStringSerializer();
    private static final AsStringSerializer DEFAULT_RADIX = new AsStringSerializer((IdConverter)Radix62IdConverter.INSTANCE);
    private static final AsStringSerializer DEFAULT_RADIX_PAD_START = new AsStringSerializer((IdConverter)Radix62IdConverter.PAD_START);
    private static final AsStringSerializer DEFAULT_FRIENDLY_ID = new AsStringSerializer(SnowflakeFriendlyIdConverter.INSTANCE);
    private final IdConverter converter;

    public AsStringSerializer() {
        this(ToStringIdConverter.INSTANCE);
    }

    public AsStringSerializer(IdConverter converter) {
        this.converter = converter;
    }

    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        AsString asString = (AsString)property.getAnnotation(AsString.class);
        switch (asString.value()) {
            case TO_STRING: {
                return TO_STRING;
            }
            case RADIX: {
                if (11 != asString.radixCharSize()) {
                    Radix62IdConverter idConverter = Radix62IdConverter.of((boolean)asString.radixPadStart(), (int)asString.radixCharSize());
                    return new AsStringSerializer((IdConverter)idConverter);
                }
                return asString.radixPadStart() ? DEFAULT_RADIX_PAD_START : DEFAULT_RADIX;
            }
            case FRIENDLY_ID: {
                if (AsStringSerializer.isDefaultSnowflakeFriendlyIdConverter(asString)) {
                    return DEFAULT_FRIENDLY_ID;
                }
                MillisecondSnowflakeIdStateParser stateParser = new MillisecondSnowflakeIdStateParser(asString.epoch(), asString.timestampBit(), asString.machineBit(), asString.sequenceBit());
                SnowflakeFriendlyIdConverter idConverter = new SnowflakeFriendlyIdConverter((SnowflakeIdStateParser)stateParser);
                return new AsStringSerializer((IdConverter)idConverter);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)asString.value()));
    }

    static boolean isDefaultSnowflakeFriendlyIdConverter(AsString asString) {
        return 1577203200000L == asString.epoch() && 41 == asString.timestampBit() && 10 == asString.machineBit() && 12 == asString.sequenceBit();
    }

    public void serialize(Long value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (Objects.isNull(value)) {
            gen.writeNull();
        } else {
            String valueStr = this.converter.asString(value.longValue());
            gen.writeString(valueStr);
        }
    }
}

