/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import me.ahoo.cosid.IdConverter;
import me.ahoo.cosid.converter.Radix62IdConverter;
import me.ahoo.cosid.converter.SnowflakeFriendlyIdConverter;
import me.ahoo.cosid.converter.ToStringIdConverter;
import me.ahoo.cosid.jackson.AsString;
import me.ahoo.cosid.jackson.AsStringSerializer;
import me.ahoo.cosid.snowflake.MillisecondSnowflakeIdStateParser;
import me.ahoo.cosid.snowflake.SnowflakeIdStateParser;

public class AsStringDeserializer
extends JsonDeserializer<Long>
implements ContextualDeserializer {
    private static final AsStringDeserializer TO_STRING = new AsStringDeserializer();
    private static final AsStringDeserializer DEFAULT_RADIX = new AsStringDeserializer(Radix62IdConverter.INSTANCE);
    private static final AsStringDeserializer DEFAULT_RADIX_PAD_START = new AsStringDeserializer(Radix62IdConverter.PAD_START);
    private static final AsStringDeserializer DEFAULT_FRIENDLY_ID = new AsStringDeserializer(SnowflakeFriendlyIdConverter.INSTANCE);
    private final IdConverter converter;

    public AsStringDeserializer() {
        this(ToStringIdConverter.INSTANCE);
    }

    public AsStringDeserializer(IdConverter converter) {
        this.converter = converter;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        AsString asString = (AsString)property.getAnnotation(AsString.class);
        if (Objects.isNull(asString)) {
            return TO_STRING;
        }
        switch (asString.value()) {
            case TO_STRING: {
                return TO_STRING;
            }
            case RADIX: {
                if (11 != asString.radixCharSize()) {
                    Radix62IdConverter idConverter = new Radix62IdConverter(asString.radixPadStart(), asString.radixCharSize());
                    return new AsStringDeserializer((IdConverter)idConverter);
                }
                return asString.radixPadStart() ? DEFAULT_RADIX_PAD_START : DEFAULT_RADIX;
            }
            case FRIENDLY_ID: {
                if (AsStringSerializer.isDefaultSnowflakeFriendlyIdConverter(asString)) {
                    return DEFAULT_FRIENDLY_ID;
                }
                MillisecondSnowflakeIdStateParser stateParser = new MillisecondSnowflakeIdStateParser(asString.epoch(), asString.timestampBit(), asString.machineBit(), asString.sequenceBit());
                SnowflakeFriendlyIdConverter idConverter = new SnowflakeFriendlyIdConverter((SnowflakeIdStateParser)stateParser);
                return new AsStringDeserializer((IdConverter)idConverter);
            }
        }
        throw new IllegalStateException("Unexpected value: " + (Object)((Object)asString.value()));
    }

    public Long deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String valueStr = p.getValueAsString();
        if (Strings.isNullOrEmpty((String)valueStr)) {
            return null;
        }
        return this.converter.asLong(valueStr);
    }
}

