/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.interval;

import com.google.common.base.Strings;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import me.ahoo.cosid.shardingsphere.sharding.interval.AbstractIntervalShardingAlgorithm;
import me.ahoo.cosid.shardingsphere.sharding.interval.NotSupportIntervalShardingTypeException;
import me.ahoo.cosid.util.LocalDateTimeConvert;

public class CosIdIntervalShardingAlgorithm
extends AbstractIntervalShardingAlgorithm<Comparable<?>> {
    public static final String TYPE = "COSID_INTERVAL";
    public static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    public static final String TIMESTAMP_SECOND_UNIT = "SECOND";
    public static final String TIMESTAMP_UNIT_KEY = "ts-unit";
    private volatile boolean isSecondTs = false;
    private volatile DateTimeFormatter dateTimeFormatter;

    @Override
    public void init() {
        super.init();
        if (this.getProps().containsKey(TIMESTAMP_UNIT_KEY) && TIMESTAMP_SECOND_UNIT.equalsIgnoreCase(this.getProps().get(TIMESTAMP_UNIT_KEY).toString())) {
            this.isSecondTs = true;
        }
        String dateTimePattern = this.getProps().getOrDefault((Object)DATE_TIME_PATTERN_KEY, "yyyy-MM-dd HH:mm:ss").toString();
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
    }

    @Override
    protected LocalDateTime convertShardingValue(Comparable<?> shardingValue) {
        if (shardingValue instanceof LocalDateTime) {
            return (LocalDateTime)shardingValue;
        }
        if (shardingValue instanceof ZonedDateTime) {
            return ((ZonedDateTime)shardingValue).toLocalDateTime();
        }
        if (shardingValue instanceof OffsetDateTime) {
            return ((OffsetDateTime)shardingValue).toLocalDateTime();
        }
        if (shardingValue instanceof Instant) {
            return LocalDateTimeConvert.fromInstant((Instant)((Instant)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof LocalDate) {
            return LocalDateTime.of((LocalDate)shardingValue, LocalTime.MIN);
        }
        if (shardingValue instanceof YearMonth) {
            YearMonth yearMonth = (YearMonth)shardingValue;
            return LocalDateTime.of(yearMonth.getYear(), yearMonth.getMonthValue(), 1, 0, 0);
        }
        if (shardingValue instanceof Year) {
            return LocalDateTime.of(((Year)shardingValue).getValue(), 1, 1, 0, 0);
        }
        if (shardingValue instanceof Date) {
            return LocalDateTimeConvert.fromDate((Date)((Date)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof Long) {
            if (this.isSecondTs) {
                return LocalDateTimeConvert.fromTimestampSecond((long)((Long)shardingValue), (ZoneId)this.getZoneId());
            }
            return LocalDateTimeConvert.fromTimestamp((long)((Long)shardingValue), (ZoneId)this.getZoneId());
        }
        if (shardingValue instanceof String) {
            return LocalDateTimeConvert.fromString((String)((String)((Object)shardingValue)), (DateTimeFormatter)this.dateTimeFormatter);
        }
        throw new NotSupportIntervalShardingTypeException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{shardingValue.getClass()}));
    }

    public String getType() {
        return TYPE;
    }
}

