/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.interval;

import com.google.common.base.Strings;
import java.time.LocalDateTime;
import java.util.Properties;
import me.ahoo.cosid.provider.LazyIdGenerator;
import me.ahoo.cosid.shardingsphere.sharding.interval.AbstractIntervalShardingAlgorithm;
import me.ahoo.cosid.shardingsphere.sharding.interval.NotSupportIntervalShardingTypeException;

public class CosIdSnowflakeIntervalShardingAlgorithm
extends AbstractIntervalShardingAlgorithm<Comparable<?>> {
    public static final String TYPE = "COSID_INTERVAL_SNOWFLAKE";
    private volatile LazyIdGenerator lazyIdGenerator;

    @Override
    public void init(Properties props) {
        super.init(props);
        this.lazyIdGenerator = new LazyIdGenerator(this.getProps().getOrDefault((Object)"id-name", "__share__").toString());
    }

    @Override
    protected LocalDateTime convertShardingValue(Comparable<?> shardingValue) {
        Long snowflakeId = this.convertToSnowflakeId(shardingValue);
        return this.lazyIdGenerator.asFriendlyId(true).getParser().parseTimestamp(snowflakeId.longValue());
    }

    private Long convertToSnowflakeId(Comparable<?> shardingValue) {
        if (shardingValue instanceof Long) {
            return (Long)shardingValue;
        }
        if (shardingValue instanceof String) {
            String shardingValueStr = (String)((Object)shardingValue);
            return this.lazyIdGenerator.idConverter().asLong(shardingValueStr);
        }
        throw new NotSupportIntervalShardingTypeException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{shardingValue.getClass()}));
    }

    public String getType() {
        return TYPE;
    }
}

