/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.mod;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.Properties;
import me.ahoo.cosid.sharding.ModCycle;
import me.ahoo.cosid.sharding.Sharding;
import me.ahoo.cosid.shardingsphere.sharding.utils.PropertiesUtil;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public class CosIdModShardingAlgorithm<T extends Number>
implements StandardShardingAlgorithm<T> {
    public static final String TYPE = "COSID_MOD";
    public static final String MODULO_KEY = "mod";
    private Properties props = new Properties();
    private volatile Sharding<T> sharding;

    public String getType() {
        return TYPE;
    }

    public Properties getProps() {
        return this.props;
    }

    @VisibleForTesting
    public Sharding<T> getSharding() {
        return this.sharding;
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        return this.sharding.sharding(shardingValue.getValue());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        return this.sharding.sharding(shardingValue.getValueRange());
    }

    public void init(Properties props) {
        this.props = props;
        String divisorStr = PropertiesUtil.getRequiredValue(this.getProps(), MODULO_KEY);
        int divisor = Integer.parseInt(divisorStr);
        String logicNamePrefix = PropertiesUtil.getRequiredValue(this.getProps(), "logic-name-prefix");
        this.sharding = new ModCycle(divisor, logicNamePrefix);
    }
}

