/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.DefaultIdGeneratorProvider;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;

@ThreadSafe
public class CosIdKeyGenerateAlgorithm
implements KeyGenerateAlgorithm {
    public static final String ID_NAME_KEY = "id-name";
    public static final String TYPE = "cosid".toUpperCase();
    private volatile IdGenerator idGenerator;
    private Properties props = new Properties();

    public Properties getProps() {
        return this.props;
    }

    public String getType() {
        return TYPE;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    private String getIdName() {
        return this.getProps().getOrDefault((Object)ID_NAME_KEY, "__share__").toString();
    }

    public void init() {
        this.initIdGen(false);
    }

    private void initIdGen(boolean required) {
        if (this.idGenerator != null) {
            return;
        }
        String idName = this.getIdName();
        Optional idGeneratorOp = DefaultIdGeneratorProvider.INSTANCE.get(idName);
        if (idGeneratorOp.isPresent()) {
            this.idGenerator = (IdGenerator)idGeneratorOp.get();
        } else if (required) {
            throw new CosIdException(Strings.lenientFormat((String)"CosId:[%s] Not Found!", (Object[])new Object[0]));
        }
    }

    public Comparable<?> generateKey() {
        this.initIdGen(true);
        return this.idGenerator.generate();
    }
}

