/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere;

import com.google.common.base.Strings;
import java.util.Optional;
import java.util.Properties;
import me.ahoo.cosid.CosIdException;
import me.ahoo.cosid.IdGenerator;
import me.ahoo.cosid.provider.DefaultIdGeneratorProvider;
import me.ahoo.cosid.snowflake.SnowflakeFriendlyId;

public final class LazyCosIdProvider {
    public static final String ID_NAME_KEY = "id-name";
    private final String idName;
    private volatile IdGenerator lazyIdGen;

    public LazyCosIdProvider(Properties properties) {
        this(properties.getOrDefault((Object)ID_NAME_KEY, "__share__").toString());
    }

    public LazyCosIdProvider(String idName) {
        this.idName = idName;
    }

    public String getIdName() {
        return this.idName;
    }

    public IdGenerator tryGetIdGenerator(boolean required) {
        if (this.lazyIdGen != null) {
            return this.lazyIdGen;
        }
        String idName = this.getIdName();
        Optional idGeneratorOp = DefaultIdGeneratorProvider.INSTANCE.get(idName);
        if (idGeneratorOp.isPresent()) {
            this.lazyIdGen = (IdGenerator)idGeneratorOp.get();
            return this.lazyIdGen;
        }
        if (required) {
            throw new CosIdException(Strings.lenientFormat((String)"CosId:[%s] Not Found!", (Object[])new Object[0]));
        }
        return null;
    }

    public SnowflakeFriendlyId tryGetFriendlyId(boolean required) {
        IdGenerator idGenerator = this.tryGetIdGenerator(required);
        if (idGenerator instanceof SnowflakeFriendlyId) {
            return (SnowflakeFriendlyId)idGenerator;
        }
        throw new CosIdException(Strings.lenientFormat((String)"CosId:[%s] is not instanceof SnowflakeFriendlyId!", (Object[])new Object[0]));
    }
}

