/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.interval;

import com.google.common.annotations.Beta;
import java.time.LocalDateTime;
import me.ahoo.cosid.shardingsphere.LazyCosIdProvider;
import me.ahoo.cosid.shardingsphere.sharding.interval.AbstractZoneIntervalShardingAlgorithm;

@Beta
public class SnowflakeIntervalShardingAlgorithm
extends AbstractZoneIntervalShardingAlgorithm<Long> {
    public static final String TYPE = "COSID_INTERVAL_SNOWFLAKE";
    private volatile LazyCosIdProvider cosIdProvider;

    @Override
    public void init() {
        super.init();
        this.cosIdProvider = new LazyCosIdProvider(this.getProps());
    }

    @Override
    protected LocalDateTime convertShardingValue(Long shardingValue) {
        return this.cosIdProvider.tryGetFriendlyId(true).getParser().parseTimestamp(shardingValue.longValue());
    }

    public String getType() {
        return TYPE;
    }
}

