/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.interval;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Properties;
import me.ahoo.cosid.shardingsphere.sharding.interval.IntervalTimeline;
import me.ahoo.cosid.shardingsphere.sharding.utils.PropertiesUtil;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public abstract class AbstractIntervalShardingAlgorithm<T extends Comparable<?>>
implements StandardShardingAlgorithm<T> {
    public static final String PREFIX_TYPE = "COSID_INTERVAL_";
    public static final String DATE_TIME_LOWER_KEY = "datetime-lower";
    public static final String DATE_TIME_UPPER_KEY = "datetime-upper";
    public static final String SHARDING_SUFFIX_FORMAT_KEY = "sharding-suffix-pattern";
    public static final String INTERVAL_UNIT_KEY = "datetime-interval-unit";
    public static final String INTERVAL_AMOUNT_KEY = "datetime-interval-amount";
    private volatile Properties props = new Properties();
    private volatile IntervalTimeline intervalTimeline;

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void init() {
        String logicName = this.getRequiredValue("logic-name");
        LocalDateTime effectiveLower = LocalDateTime.parse(this.getRequiredValue(DATE_TIME_LOWER_KEY));
        LocalDateTime effectiveUpper = LocalDateTime.parse(this.getRequiredValue(DATE_TIME_UPPER_KEY));
        DateTimeFormatter suffixFormatter = DateTimeFormatter.ofPattern(this.getRequiredValue(SHARDING_SUFFIX_FORMAT_KEY));
        ChronoUnit stepUnit = ChronoUnit.valueOf(this.getRequiredValue(INTERVAL_UNIT_KEY));
        int stepAmount = Integer.parseInt(this.getProps().getProperty(INTERVAL_AMOUNT_KEY, "1"));
        this.intervalTimeline = new IntervalTimeline(logicName, (Range<LocalDateTime>)Range.closed((Comparable)effectiveLower, (Comparable)effectiveUpper), IntervalTimeline.Step.of(stepUnit, stepAmount), suffixFormatter);
    }

    protected String getRequiredValue(String key) {
        return PropertiesUtil.getRequiredValue(this.getProps(), key);
    }

    @VisibleForTesting
    public IntervalTimeline getIntervalTimeline() {
        return this.intervalTimeline;
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        LocalDateTime shardingTime = this.convertShardingValue(shardingValue.getValue());
        return this.intervalTimeline.sharding(shardingTime);
    }

    protected abstract LocalDateTime convertShardingValue(T var1);

    protected Range<LocalDateTime> convertRangeShardingValue(Range<T> shardingValue) {
        LocalDateTime lower = this.convertShardingValue(shardingValue.lowerEndpoint());
        LocalDateTime upper = this.convertShardingValue(shardingValue.upperEndpoint());
        return Range.range((Comparable)lower, (BoundType)shardingValue.lowerBoundType(), (Comparable)upper, (BoundType)shardingValue.upperBoundType());
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        Range<LocalDateTime> shardingRangeTime = this.convertRangeShardingValue(shardingValue.getValueRange());
        return this.intervalTimeline.sharding(shardingRangeTime);
    }
}

