/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.interval;

import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.ThreadSafe;
import me.ahoo.cosid.shardingsphere.sharding.Sharding;
import me.ahoo.cosid.shardingsphere.sharding.utils.ExactCollection;

@ThreadSafe
public class IntervalTimeline
implements Sharding<LocalDateTime> {
    private final Range<LocalDateTime> effectiveInterval;
    private final Step step;
    private final Interval startInterval;
    private final Interval[] effectiveIntervals;
    private final String logicName;
    private final DateTimeFormatter suffixFormatter;
    private final Collection<String> allNodes;

    public IntervalTimeline(String logicName, Range<LocalDateTime> effectiveInterval, Step step, DateTimeFormatter suffixFormatter) {
        this.effectiveInterval = effectiveInterval;
        this.step = step;
        this.logicName = logicName;
        this.suffixFormatter = suffixFormatter;
        this.effectiveIntervals = IntervalTimeline.initIntervals(effectiveInterval, step, logicName, suffixFormatter);
        this.startInterval = this.effectiveIntervals[0];
        this.allNodes = (Collection)Arrays.stream(this.effectiveIntervals).map(Interval::getNode).collect(ImmutableSet.toImmutableSet());
    }

    private static Interval[] initIntervals(Range<LocalDateTime> effectiveInterval, Step step, String logicName, DateTimeFormatter suffixFormatter) {
        LocalDateTime lower = step.ofUnit((LocalDateTime)effectiveInterval.lowerEndpoint());
        LocalDateTime upper = step.ofUnit((LocalDateTime)effectiveInterval.upperEndpoint());
        ArrayList<Interval> intervalList = new ArrayList<Interval>();
        while (!lower.isAfter(upper)) {
            String nodeName = logicName + lower.format(suffixFormatter);
            intervalList.add(new Interval(lower, nodeName));
            lower = step.next(lower);
        }
        return intervalList.toArray(new Interval[intervalList.size()]);
    }

    public int size() {
        return this.effectiveIntervals.length;
    }

    public boolean contains(LocalDateTime time) {
        return this.effectiveInterval.contains((Comparable)time);
    }

    public Interval getStartInterval() {
        return this.startInterval;
    }

    public Collection<String> getAllNodes() {
        return this.allNodes;
    }

    @Override
    public String sharding(LocalDateTime shardingValue) {
        if (!this.contains(shardingValue)) {
            return null;
        }
        int offset = this.step.unitOffset(this.startInterval.getLower(), shardingValue);
        return this.effectiveIntervals[offset].getNode();
    }

    @Override
    public Collection<String> sharding(Range<LocalDateTime> shardingValue) {
        int upperOffset;
        int lowerOffset;
        if (!this.effectiveInterval.isConnected(shardingValue)) {
            return Collections.emptyList();
        }
        int maxOffset = this.size() - 1;
        int n = lowerOffset = !shardingValue.hasLowerBound() ? 0 : this.step.unitOffset(this.startInterval.getLower(), (LocalDateTime)shardingValue.lowerEndpoint());
        if (lowerOffset < 0) {
            lowerOffset = 0;
        }
        int n2 = upperOffset = !shardingValue.hasUpperBound() ? maxOffset : this.step.unitOffset(this.startInterval.getLower(), (LocalDateTime)shardingValue.upperEndpoint());
        if (upperOffset > maxOffset) {
            upperOffset = maxOffset;
        }
        if (lowerOffset == 0 && upperOffset == maxOffset) {
            return this.allNodes;
        }
        Interval lastInterval = this.effectiveIntervals[upperOffset];
        if (lowerOffset == upperOffset) {
            return Collections.singleton(lastInterval.getNode());
        }
        if (shardingValue.hasUpperBound() && BoundType.OPEN.equals((Object)shardingValue.upperBoundType()) && lastInterval.getLower().equals(shardingValue.upperEndpoint())) {
            --upperOffset;
        }
        int nodeSize = upperOffset - lowerOffset + 1;
        ExactCollection<String> nodes = new ExactCollection<String>(nodeSize);
        int idx = 0;
        while (lowerOffset <= upperOffset) {
            Interval interval = this.effectiveIntervals[lowerOffset];
            nodes.add(idx, interval.getNode());
            ++lowerOffset;
            ++idx;
        }
        return nodes;
    }

    public static class Step {
        public static final int DEFAULT_AMOUNT = 1;
        private final ChronoUnit unit;
        private final int amount;

        public Step(ChronoUnit unit, int amount) {
            this.unit = unit;
            this.amount = amount;
        }

        public ChronoUnit getUnit() {
            return this.unit;
        }

        public int getAmount() {
            return this.amount;
        }

        public LocalDateTime next(LocalDateTime previous) {
            return previous.plus(this.amount, this.unit);
        }

        public LocalDateTime ofUnit(LocalDateTime time) {
            switch (this.unit) {
                case YEARS: {
                    return LocalDateTime.of(time.getYear(), 1, 1, 0, 0);
                }
                case MONTHS: {
                    return LocalDateTime.of(time.getYear(), time.getMonthValue(), 1, 0, 0);
                }
                case DAYS: {
                    return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), 0, 0);
                }
                case HOURS: {
                    return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), 0);
                }
                case MINUTES: {
                    return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute());
                }
                case SECONDS: {
                    return LocalDateTime.of(time.getYear(), time.getMonthValue(), time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
                }
            }
            throw new IllegalStateException("Unexpected value: " + this.unit);
        }

        public int unitOffset(LocalDateTime startInterval, LocalDateTime time) {
            return this.getDiffUint(startInterval, time) / this.amount;
        }

        private int getDiffUint(LocalDateTime startInterval, LocalDateTime time) {
            switch (this.unit) {
                case YEARS: {
                    return this.getDiffYear(startInterval, time);
                }
                case MONTHS: {
                    return this.getDiffYearMonth(startInterval, time);
                }
                case DAYS: {
                    return this.getDiffYearMonthDay(startInterval, time);
                }
                case HOURS: {
                    return this.getDiffYearMonthDay(startInterval, time) * 24;
                }
                case MINUTES: {
                    return this.getDiffYearMonthDay(startInterval, time) * 24 * 60;
                }
                case SECONDS: {
                    return this.getDiffYearMonthDay(startInterval, time) * 24 * 60 * 60;
                }
            }
            throw new IllegalStateException("Unexpected value: " + this.unit);
        }

        private int getDiffYearMonthDay(LocalDateTime startInterval, LocalDateTime time) {
            return (int)(time.toLocalDate().toEpochDay() - startInterval.toLocalDate().toEpochDay());
        }

        private int getDiffYearMonth(LocalDateTime startInterval, LocalDateTime time) {
            return this.getDiffYear(startInterval, time) * 12 + (time.getMonthValue() - startInterval.getMonthValue());
        }

        private int getDiffYear(LocalDateTime startInterval, LocalDateTime time) {
            return time.getYear() - startInterval.getYear();
        }

        public static Step of(ChronoUnit unit) {
            return new Step(unit, 1);
        }

        public static Step of(ChronoUnit unit, int amount) {
            return new Step(unit, amount);
        }
    }

    public static class Interval {
        private final LocalDateTime lower;
        private final String node;

        public Interval(LocalDateTime lower, String node) {
            this.lower = lower;
            this.node = node;
        }

        public LocalDateTime getLower() {
            return this.lower;
        }

        public String getNode() {
            return this.node;
        }
    }
}

