/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.mod;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collection;
import me.ahoo.cosid.shardingsphere.sharding.Sharding;
import me.ahoo.cosid.shardingsphere.sharding.utils.ExactCollection;

public class ModCycle
implements Sharding<Long> {
    private final int divisor;
    private final String logicNamePrefix;
    private ExactCollection<String> effectiveNodes;

    public ModCycle(int divisor, String logicNamePrefix) {
        this.divisor = divisor;
        this.logicNamePrefix = logicNamePrefix;
        this.effectiveNodes = ModCycle.initNodes(divisor, logicNamePrefix);
    }

    private static ExactCollection<String> initNodes(int divisor, String logicNamePrefix) {
        ExactCollection<String> modNodes = new ExactCollection<String>(divisor);
        for (int i = 0; i < divisor; ++i) {
            String nodeName = logicNamePrefix + i;
            modNodes.add(i, nodeName);
        }
        return modNodes;
    }

    public int getDivisor() {
        return this.divisor;
    }

    @Override
    public String sharding(Long shardingValue) {
        int nodeIdx = (int)(shardingValue % (long)this.divisor);
        return this.effectiveNodes.get(nodeIdx);
    }

    @Override
    public Collection<String> sharding(Range<Long> shardingValue) {
        long upper;
        if (!shardingValue.hasLowerBound() || !shardingValue.hasUpperBound()) {
            return this.effectiveNodes;
        }
        long lower = BoundType.OPEN.equals((Object)shardingValue.lowerBoundType()) ? (Long)shardingValue.lowerEndpoint() + 1L : (Long)shardingValue.lowerEndpoint();
        long l = upper = BoundType.OPEN.equals((Object)shardingValue.upperBoundType()) ? (Long)shardingValue.upperEndpoint() - 1L : (Long)shardingValue.upperEndpoint();
        if (upper - lower >= (long)this.divisor) {
            return this.effectiveNodes;
        }
        int nodeSize = (int)(upper - lower + 1L);
        ExactCollection<String> nodes = new ExactCollection<String>(nodeSize);
        int idx = 0;
        while (lower <= upper) {
            int modValue = (int)(lower % (long)this.divisor);
            String matchedNode = this.effectiveNodes.get(modValue);
            nodes.add(idx, matchedNode);
            ++lower;
            ++idx;
        }
        return nodes;
    }

    public Collection<String> getAllNodes() {
        return this.effectiveNodes;
    }
}

