/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.mod;

import com.google.common.base.Strings;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Properties;
import me.ahoo.cosid.shardingsphere.sharding.mod.ModCycle;
import me.ahoo.cosid.shardingsphere.sharding.mod.NotSupportModShardingTypeException;
import me.ahoo.cosid.shardingsphere.sharding.utils.PropertiesUtil;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.RangeShardingValue;
import org.apache.shardingsphere.sharding.api.sharding.standard.StandardShardingAlgorithm;

public class ModShardingAlgorithm<T extends Comparable<?>>
implements StandardShardingAlgorithm<T> {
    public static final String TYPE = "COSID_MOD";
    public static final String MODULO_KEY = "mod";
    public static final String LOGIC_NAME_PREFIX_KEY = "logic-name-prefix";
    private volatile Properties props = new Properties();
    private volatile ModCycle modCycle;

    public String getType() {
        return TYPE;
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public ModCycle getModCycle() {
        return this.modCycle;
    }

    public String doSharding(Collection<String> availableTargetNames, PreciseShardingValue<T> shardingValue) {
        Comparable value = shardingValue.getValue();
        if (value instanceof Integer) {
            return this.modCycle.sharding(((Integer)shardingValue.getValue()).longValue());
        }
        if (value instanceof Long) {
            return this.modCycle.sharding((Long)shardingValue.getValue());
        }
        throw new NotSupportModShardingTypeException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{shardingValue.getClass()}));
    }

    public Collection<String> doSharding(Collection<String> availableTargetNames, RangeShardingValue<T> shardingValue) {
        Comparable value;
        Range shardingValueRange = shardingValue.getValueRange();
        Comparable comparable = value = shardingValueRange.hasLowerBound() ? shardingValueRange.lowerEndpoint() : shardingValueRange.upperEndpoint();
        if (value instanceof Integer) {
            Range rangeShardingValue = Range.range((Comparable)Long.valueOf(((Integer)shardingValueRange.lowerEndpoint()).longValue()), (BoundType)shardingValueRange.lowerBoundType(), (Comparable)Long.valueOf(((Integer)shardingValueRange.upperEndpoint()).longValue()), (BoundType)shardingValueRange.upperBoundType());
            return this.modCycle.sharding((Range<Long>)rangeShardingValue);
        }
        if (value instanceof Long) {
            Range rangeShardingValue = Range.range((Comparable)((Long)shardingValueRange.lowerEndpoint()), (BoundType)shardingValueRange.lowerBoundType(), (Comparable)((Long)shardingValueRange.upperEndpoint()), (BoundType)shardingValueRange.upperBoundType());
            return this.modCycle.sharding((Range<Long>)rangeShardingValue);
        }
        throw new NotSupportModShardingTypeException(Strings.lenientFormat((String)"The current shard type:[%s] is not supported!", (Object[])new Object[]{value.getClass()}));
    }

    public void init() {
        int divisor = Integer.parseInt(PropertiesUtil.getRequiredValue(this.getProps(), MODULO_KEY));
        String logicNamePrefix = PropertiesUtil.getRequiredValue(this.getProps(), LOGIC_NAME_PREFIX_KEY);
        this.modCycle = new ModCycle(divisor, logicNamePrefix);
    }
}

