/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.interval;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import me.ahoo.cosid.shardingsphere.sharding.interval.AbstractIntervalShardingAlgorithm;
import me.ahoo.cosid.util.LocalDateTimeConvert;

public class StringIntervalShardingAlgorithm
extends AbstractIntervalShardingAlgorithm<String> {
    public static final String TYPE = "COSID_INTERVAL_STRING";
    public static final String DATE_TIME_PATTERN_KEY = "datetime-pattern";
    private volatile DateTimeFormatter dateTimeFormatter;

    @Override
    public void init() {
        super.init();
        String dateTimePattern = this.getProps().getProperty(DATE_TIME_PATTERN_KEY, "yyyy-MM-dd HH:mm:ss");
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimePattern);
    }

    @Override
    protected LocalDateTime convertShardingValue(String shardingValue) {
        return LocalDateTimeConvert.fromString((String)shardingValue, (DateTimeFormatter)this.dateTimeFormatter);
    }

    public String getType() {
        return TYPE;
    }
}

