/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.shardingsphere.sharding.key;

import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import me.ahoo.cosid.provider.LazyIdGenerator;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmPostProcessor;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.spi.typed.TypedSPI;

@ThreadSafe
public class CosIdKeyGenerateAlgorithm
implements TypedSPI,
ShardingSphereAlgorithmPostProcessor,
KeyGenerateAlgorithm {
    public static final String TYPE = "cosid".toUpperCase();
    public static final String AS_STRING_KEY = "as-string";
    private volatile Properties props = new Properties();
    protected volatile LazyIdGenerator cosIdProvider;
    private volatile boolean asString;

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    public void init() {
        this.cosIdProvider = new LazyIdGenerator(this.getProps().getOrDefault((Object)"id-name", "__share__").toString());
        String asStringStr = this.getProps().getProperty(AS_STRING_KEY, Boolean.FALSE.toString());
        this.asString = Boolean.parseBoolean(asStringStr);
        this.cosIdProvider.tryGet(false);
    }

    public String getType() {
        return TYPE;
    }

    public Comparable<?> generateKey() {
        if (this.asString) {
            return this.cosIdProvider.generateAsString();
        }
        return this.cosIdProvider.generate();
    }
}

