/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.util.List;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeOverflow
implements TestSpec {
    private final Supplier<MachineIdDistributor> implFactory;

    public DistributeOverflow(Supplier<MachineIdDistributor> implFactory) {
        this.implFactory = implFactory;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("DistributeOverflow").generateAsString();
        List<InstanceId> allInstances = MachineIdDistributorSpec.allInstancesMoreOne(5, false);
        MatcherAssert.assertThat(allInstances, (Matcher)Matchers.hasSize((int)(MachineIdDistributor.totalMachineIds((int)5) + 1)));
        for (int i = 0; i < allInstances.size() - 1; ++i) {
            int machineId = distributor.distribute(namespace, 5, allInstances.get(i), MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
        InstanceId overflowInstanceId = allInstances.get(MachineIdDistributor.totalMachineIds((int)5));
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, 5, overflowInstanceId, MachineIdDistributor.FOREVER_SAFE_GUARD_DURATION));
    }
}

