/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.test.machine.distributor.Distribute;
import me.ahoo.cosid.test.machine.distributor.DistributeConcurrent;
import me.ahoo.cosid.test.machine.distributor.DistributeIdempotent;
import me.ahoo.cosid.test.machine.distributor.DistributeOverflow;
import me.ahoo.cosid.test.machine.distributor.DistributeRevert;
import me.ahoo.cosid.test.machine.distributor.DistributeSafeGuard;
import me.ahoo.cosid.test.machine.distributor.DistributeStable;
import me.ahoo.cosid.test.machine.distributor.Guard;
import me.ahoo.cosid.test.machine.distributor.GuardLost;
import me.ahoo.cosid.test.machine.distributor.Revert;
import org.junit.jupiter.api.Test;

public abstract class MachineIdDistributorSpec {
    public static final String TEST_HOST = "127.0.0.1";
    public static final int TEST_MACHINE_BIT = 5;

    static InstanceId mockInstance(int port, boolean stable) {
        return InstanceId.of((String)TEST_HOST, (int)port, (boolean)stable);
    }

    static List<InstanceId> mockInstances(int totalMachineIds, boolean stable) {
        ArrayList instanceIds = Lists.newArrayListWithCapacity((int)totalMachineIds);
        for (int i = 0; i < totalMachineIds; ++i) {
            InstanceId instanceId = MachineIdDistributorSpec.mockInstance(i, stable);
            instanceIds.add(instanceId);
        }
        return instanceIds;
    }

    static List<InstanceId> allInstances(int machineBit, boolean stable) {
        int totalMachineIds = MachineIdDistributor.totalMachineIds((int)machineBit);
        return MachineIdDistributorSpec.mockInstances(totalMachineIds, stable);
    }

    static List<InstanceId> allInstancesMoreOne(int machineBit, boolean stable) {
        int totalMachineIds = MachineIdDistributor.totalMachineIds((int)machineBit);
        return MachineIdDistributorSpec.mockInstances(totalMachineIds + 1, stable);
    }

    protected abstract MachineIdDistributor getDistributor();

    @Test
    public void distribute() {
        new Distribute(this::getDistributor).verify();
    }

    @Test
    public void distributeOverflow() {
        new DistributeOverflow(this::getDistributor).verify();
    }

    @Test
    public void distributeRevert() {
        new DistributeRevert(this::getDistributor).verify();
    }

    @Test
    public void distributeSafeGuard() {
        new DistributeSafeGuard(this::getDistributor).verify();
    }

    @Test
    public void guard() {
        new Guard(this::getDistributor).verify();
    }

    @Test
    public void guardLost() {
        new GuardLost(this::getDistributor).verify();
    }

    @Test
    public void distributeStable() {
        new DistributeStable(this::getDistributor).verify();
    }

    @Test
    public void revert() {
        new Revert(this::getDistributor).verify();
    }

    @Test
    public void distributeConcurrent() {
        new DistributeConcurrent(this::getDistributor).verify();
    }

    @Test
    public void distributeIdempotent() {
        new DistributeIdempotent(this::getDistributor).verify();
    }
}

