/*
 * Decompiled with CFR 0.152.
 */
package me.ahoo.cosid.test.machine.distributor;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import me.ahoo.cosid.machine.InstanceId;
import me.ahoo.cosid.machine.MachineIdDistributor;
import me.ahoo.cosid.machine.MachineIdOverflowException;
import me.ahoo.cosid.test.Assert;
import me.ahoo.cosid.test.MockIdGenerator;
import me.ahoo.cosid.test.TestSpec;
import me.ahoo.cosid.test.machine.distributor.MachineIdDistributorSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class DistributeSafeGuard
implements TestSpec {
    public static final Duration SAFE_GUARD_DURATION = Duration.ofSeconds(5L);
    private final Supplier<MachineIdDistributor> implFactory;

    public DistributeSafeGuard(Supplier<MachineIdDistributor> implFactory) {
        this.implFactory = implFactory;
    }

    @Override
    public void verify() {
        MachineIdDistributor distributor = this.implFactory.get();
        String namespace = MockIdGenerator.usePrefix("DistributeSafeGuard").generateAsString();
        int machineBit = 5;
        int moreMachineBit = machineBit + 1;
        List<InstanceId> allInstances = MachineIdDistributorSpec.allInstances(moreMachineBit, false);
        int endIdx = MachineIdDistributor.totalMachineIds((int)machineBit);
        List<InstanceId> availableInstances = allInstances.subList(0, endIdx);
        MatcherAssert.assertThat(availableInstances, (Matcher)Matchers.hasSize((int)MachineIdDistributor.totalMachineIds((int)machineBit)));
        for (int i = 0; i < availableInstances.size(); ++i) {
            int machineId = distributor.distribute(namespace, 5, allInstances.get(i), SAFE_GUARD_DURATION).getMachineId();
            MatcherAssert.assertThat((Object)machineId, (Matcher)Matchers.equalTo((Object)i));
        }
        InstanceId overflowInstanceId = MachineIdDistributorSpec.mockInstance(MachineIdDistributor.totalMachineIds((int)machineBit), false);
        Assert.assertThrows(MachineIdOverflowException.class, () -> distributor.distribute(namespace, machineBit, overflowInstanceId, SAFE_GUARD_DURATION));
        LockSupport.parkNanos(this, SAFE_GUARD_DURATION.plusMillis(10L).toNanos());
        availableInstances = allInstances.subList(endIdx, MachineIdDistributor.totalMachineIds((int)moreMachineBit));
        Integer[] machineIds = (Integer[])availableInstances.stream().map(instanceId -> distributor.distribute(namespace, machineBit, instanceId, SAFE_GUARD_DURATION).getMachineId()).sorted().toArray(Integer[]::new);
        for (int i = 0; i < machineIds.length; ++i) {
            MatcherAssert.assertThat((Object)machineIds[i], (Matcher)Matchers.equalTo((Object)i));
        }
    }
}

